/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.ollama.chat;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.lnyocly.ai4j.config.OllamaConfig;
import io.github.lnyocly.ai4j.convert.chat.ParameterConvert;
import io.github.lnyocly.ai4j.convert.chat.ResultConvert;
import io.github.lnyocly.ai4j.exception.CommonException;
import io.github.lnyocly.ai4j.listener.SseListener;
import io.github.lnyocly.ai4j.platform.ollama.chat.entity.OllamaChatCompletion;
import io.github.lnyocly.ai4j.platform.ollama.chat.entity.OllamaChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.ollama.chat.entity.OllamaMessage;
import io.github.lnyocly.ai4j.platform.ollama.chat.entity.OllamaOptions;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletion;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.Choice;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.Content;
import io.github.lnyocly.ai4j.platform.openai.chat.enums.ChatMessageType;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import io.github.lnyocly.ai4j.platform.openai.tool.ToolCall;
import io.github.lnyocly.ai4j.platform.openai.usage.Usage;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IChatService;
import io.github.lnyocly.ai4j.utils.ToolUtil;
import io.github.lnyocly.ai4j.utils.ValidateUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OllamaAiChatService
implements IChatService,
ParameterConvert<OllamaChatCompletion>,
ResultConvert<OllamaChatCompletionResponse> {
    private final OllamaConfig ollamaConfig;
    private final OkHttpClient okHttpClient;
    private final EventSource.Factory factory;

    public OllamaAiChatService(Configuration configuration) {
        this.ollamaConfig = configuration.getOllamaConfig();
        this.okHttpClient = configuration.getOkHttpClient();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public OllamaChatCompletion convertChatCompletionObject(ChatCompletion chatCompletion) {
        OllamaChatCompletion ollamaChatCompletion = new OllamaChatCompletion();
        ollamaChatCompletion.setModel(chatCompletion.getModel());
        ollamaChatCompletion.setTools(chatCompletion.getTools());
        ollamaChatCompletion.setFunctions(chatCompletion.getFunctions());
        ollamaChatCompletion.setStream(chatCompletion.getStream());
        OllamaOptions ollamaOptions = new OllamaOptions();
        ollamaOptions.setTemperature(chatCompletion.getTemperature());
        ollamaOptions.setTopP(chatCompletion.getTopP());
        ollamaOptions.setStop(chatCompletion.getStop());
        ollamaChatCompletion.setOptions(ollamaOptions);
        ArrayList<OllamaMessage> messages = new ArrayList<OllamaMessage>();
        for (ChatMessage chatMessage : chatCompletion.getMessages()) {
            List<Content.MultiModal> multiModals;
            OllamaMessage ollamaMessage = new OllamaMessage();
            ollamaMessage.setRole(chatMessage.getRole());
            String content = chatMessage.getContent().getText();
            if (content != null) {
                ollamaMessage.setContent(content);
            } else if (chatMessage.getContent().getMultiModals() != null && (multiModals = chatMessage.getContent().getMultiModals()) != null && !multiModals.isEmpty()) {
                ArrayList<String> images = new ArrayList<String>();
                for (Content.MultiModal multiModal : multiModals) {
                    String text = multiModal.getText();
                    Content.MultiModal.ImageUrl imageUrl = multiModal.getImageUrl();
                    if (imageUrl != null) {
                        images.add(imageUrl.getUrl());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)text)) continue;
                    ollamaMessage.setContent(text);
                }
                ollamaMessage.setImages(images);
            }
            ollamaMessage.setToolCalls(chatMessage.getToolCalls());
            messages.add(ollamaMessage);
        }
        ollamaChatCompletion.setMessages(messages);
        return ollamaChatCompletion;
    }

    public List<ChatMessage> ollamaMessagesToChatMessages(List<OllamaMessage> ollamaMessages) {
        ArrayList<ChatMessage> chatMessages = new ArrayList<ChatMessage>();
        for (OllamaMessage ollamaMessage : ollamaMessages) {
            chatMessages.add(this.ollamaMessageToChatMessage(ollamaMessage));
        }
        return chatMessages;
    }

    public ChatMessage ollamaMessageToChatMessage(OllamaMessage ollamaMessage) {
        String role = ollamaMessage.getRole();
        List<ToolCall> toolCalls = ollamaMessage.getToolCalls();
        if (ChatMessageType.USER.getRole().equals(role)) {
            if (ollamaMessage.getImages() != null && !ollamaMessage.getImages().isEmpty()) {
                return ChatMessage.withUser(ollamaMessage.getContent(), ollamaMessage.getImages().toArray(new String[0]));
            }
            return ChatMessage.withUser(ollamaMessage.getContent());
        }
        if (ChatMessageType.ASSISTANT.getRole().equals(role)) {
            if (toolCalls != null && !toolCalls.isEmpty()) {
                for (ToolCall toolCall : toolCalls) {
                    toolCall.setType("function");
                    toolCall.setId(UUID.randomUUID().toString());
                }
                return ChatMessage.withAssistant(toolCalls);
            }
            return ChatMessage.withAssistant(ollamaMessage.getContent());
        }
        return new ChatMessage(role, ollamaMessage.getContent());
    }

    @Override
    public EventSourceListener convertEventSource(final SseListener eventSourceListener) {
        return new EventSourceListener(){

            public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
                eventSourceListener.onOpen(eventSource, response);
            }

            public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                eventSourceListener.onFailure(eventSource, t, response);
            }

            public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
                if ("[DONE]".equalsIgnoreCase(data)) {
                    eventSourceListener.onEvent(eventSource, id, type, data);
                    return;
                }
                OllamaChatCompletionResponse ollamaChatCompletionResponse = (OllamaChatCompletionResponse)JSON.parseObject((String)data, OllamaChatCompletionResponse.class);
                ChatCompletionResponse response = OllamaAiChatService.this.convertChatCompletionResponse(ollamaChatCompletionResponse);
                ObjectMapper mapper = new ObjectMapper();
                String s = null;
                try {
                    s = mapper.writeValueAsString((Object)response);
                }
                catch (JsonProcessingException e) {
                    throw new CommonException("Ollama Chat Completion Response convert to JSON error");
                }
                eventSourceListener.onEvent(eventSource, id, type, s);
            }

            public void onClosed(@NotNull EventSource eventSource) {
                eventSourceListener.onClosed(eventSource);
            }
        };
    }

    @Override
    public ChatCompletionResponse convertChatCompletionResponse(OllamaChatCompletionResponse ollamaChatCompletionResponse) {
        ChatCompletionResponse chatCompletionResponse = new ChatCompletionResponse();
        chatCompletionResponse.setModel(ollamaChatCompletionResponse.getModel());
        chatCompletionResponse.setId(UUID.randomUUID().toString());
        chatCompletionResponse.setObject("chat.completion");
        Instant instant = Instant.parse(ollamaChatCompletionResponse.getCreatedAt());
        long created = instant.getEpochSecond();
        chatCompletionResponse.setCreated(created);
        Usage usage = new Usage();
        usage.setCompletionTokens(ollamaChatCompletionResponse.getEvalCount());
        usage.setPromptTokens(ollamaChatCompletionResponse.getPromptEvalCount());
        usage.setTotalTokens(ollamaChatCompletionResponse.getEvalCount() + ollamaChatCompletionResponse.getPromptEvalCount());
        chatCompletionResponse.setUsage(usage);
        ChatMessage chatMessage = this.ollamaMessageToChatMessage(ollamaChatCompletionResponse.getMessage());
        ArrayList<Choice> choices = new ArrayList<Choice>(1);
        Choice choice = new Choice();
        choice.setFinishReason(ollamaChatCompletionResponse.getDoneReason());
        choice.setIndex(0);
        choice.setMessage(chatMessage);
        choice.setDelta(chatMessage);
        choices.add(choice);
        chatCompletionResponse.setChoices(choices);
        return chatCompletionResponse;
    }

    @Override
    public ChatCompletionResponse chatCompletion(String baseUrl, String apiKey, ChatCompletion chatCompletion) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.ollamaConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.ollamaConfig.getApiKey();
        }
        chatCompletion.setStream(false);
        chatCompletion.setStreamOptions(null);
        OllamaChatCompletion ollamaChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (ollamaChatCompletion.getFunctions() != null && !ollamaChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(ollamaChatCompletion.getFunctions());
            ollamaChatCompletion.setTools(tools);
        }
        Usage allUsage = new Usage();
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            Request request;
            Response execute;
            finishReason = null;
            String requestString = JSON.toJSONString((Object)ollamaChatCompletion);
            JSONObject jsonObject = JSON.parseObject((String)requestString);
            JSONArray jsonArrayMessages = jsonObject.getJSONArray("messages");
            for (Object message : jsonArrayMessages) {
                JSONObject messageObject = (JSONObject)message;
                JSONArray toolCalls = messageObject.getJSONArray("tool_calls");
                if (toolCalls == null || toolCalls.isEmpty()) continue;
                for (Object toolCall : toolCalls) {
                    JSONObject toolCallObject = (JSONObject)toolCall;
                    JSONObject function = toolCallObject.getJSONObject("function");
                    String arguments = function.getString("arguments");
                    JSONObject argumentsObject = JSON.parseObject((String)arguments);
                    function.remove((Object)"arguments");
                    function.put((Object)"arguments", (Object)argumentsObject);
                }
            }
            requestString = JSON.toJSONString((Object)jsonObject);
            Request.Builder builder = new Request.Builder().url(ValidateUtil.concatUrl(baseUrl, this.ollamaConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestString));
            if (StringUtils.isNotBlank((CharSequence)apiKey)) {
                builder.header("Authorization", "Bearer " + apiKey);
            }
            if (!(execute = this.okHttpClient.newCall(request = builder.build()).execute()).isSuccessful() || execute.body() == null) continue;
            OllamaChatCompletionResponse ollamaChatCompletionResponse = (OllamaChatCompletionResponse)JSON.parseObject((String)execute.body().string(), OllamaChatCompletionResponse.class);
            finishReason = ollamaChatCompletionResponse.getDoneReason();
            allUsage.setCompletionTokens(allUsage.getCompletionTokens() + ollamaChatCompletionResponse.getEvalCount());
            allUsage.setTotalTokens(allUsage.getTotalTokens() + ollamaChatCompletionResponse.getEvalCount() + ollamaChatCompletionResponse.getPromptEvalCount());
            allUsage.setPromptTokens(allUsage.getPromptTokens() + ollamaChatCompletionResponse.getPromptEvalCount());
            List<ToolCall> functions = ollamaChatCompletionResponse.getMessage().getToolCalls();
            if (functions != null && !functions.isEmpty()) {
                finishReason = "tool_calls";
            }
            if ("tool_calls".equals(finishReason)) {
                OllamaMessage message = ollamaChatCompletionResponse.getMessage();
                List<ToolCall> toolCalls = message.getToolCalls();
                ArrayList<OllamaMessage> messages = new ArrayList<OllamaMessage>(ollamaChatCompletion.getMessages());
                messages.add(message);
                for (ToolCall toolCall : toolCalls) {
                    String functionName = toolCall.getFunction().getName();
                    String arguments = toolCall.getFunction().getArguments();
                    String functionResponse = ToolUtil.invoke(functionName, arguments);
                    OllamaMessage ollamaMessage = new OllamaMessage();
                    ollamaMessage.setRole("tool");
                    ollamaMessage.setContent(functionResponse);
                    messages.add(ollamaMessage);
                }
                ollamaChatCompletion.setMessages(messages);
                continue;
            }
            ollamaChatCompletionResponse.setEvalCount(allUsage.getCompletionTokens());
            ollamaChatCompletionResponse.setPromptEvalCount(allUsage.getPromptTokens());
            chatCompletion.setMessages(this.ollamaMessagesToChatMessages(ollamaChatCompletion.getMessages()));
            chatCompletion.setTools(ollamaChatCompletion.getTools());
            return this.convertChatCompletionResponse(ollamaChatCompletionResponse);
        }
        return null;
    }

    @Override
    public ChatCompletionResponse chatCompletion(ChatCompletion chatCompletion) throws Exception {
        return this.chatCompletion(null, null, chatCompletion);
    }

    @Override
    public void chatCompletionStream(String baseUrl, String apiKey, ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.ollamaConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.ollamaConfig.getApiKey();
        }
        chatCompletion.setStream(true);
        OllamaChatCompletion ollamaChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (ollamaChatCompletion.getFunctions() != null && !ollamaChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(ollamaChatCompletion.getFunctions());
            ollamaChatCompletion.setTools(tools);
        }
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            String arguments;
            finishReason = null;
            JSON.toJSONString((Object)ollamaChatCompletion);
            ObjectMapper mapper = new ObjectMapper();
            String requestString = mapper.writeValueAsString((Object)ollamaChatCompletion);
            JSONObject jsonObject = JSON.parseObject((String)requestString);
            JSONArray jsonArrayMessages = jsonObject.getJSONArray("messages");
            for (Object message : jsonArrayMessages) {
                JSONObject messageObject = (JSONObject)message;
                JSONArray toolCalls = messageObject.getJSONArray("tool_calls");
                if (toolCalls == null || toolCalls.isEmpty()) continue;
                for (Object toolCall : toolCalls) {
                    JSONObject toolCallObject = (JSONObject)toolCall;
                    JSONObject function = toolCallObject.getJSONObject("function");
                    arguments = function.getString("arguments");
                    JSONObject argumentsObject = JSON.parseObject((String)arguments);
                    function.remove((Object)"arguments");
                    function.put((Object)"arguments", (Object)argumentsObject);
                }
            }
            requestString = JSON.toJSONString((Object)jsonObject);
            Request.Builder builder = new Request.Builder().url(ValidateUtil.concatUrl(baseUrl, this.ollamaConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestString));
            if (StringUtils.isNotBlank((CharSequence)apiKey)) {
                builder.header("Authorization", "Bearer " + apiKey);
            }
            Request request = builder.build();
            this.factory.newEventSource(request, this.convertEventSource(eventSourceListener));
            eventSourceListener.getCountDownLatch().await();
            finishReason = eventSourceListener.getFinishReason();
            List<ToolCall> toolCalls = eventSourceListener.getToolCalls();
            if (!"tool_calls".equals(finishReason) || toolCalls.isEmpty()) continue;
            OllamaMessage responseMessage = new OllamaMessage();
            responseMessage.setRole(ChatMessageType.ASSISTANT.getRole());
            responseMessage.setToolCalls(eventSourceListener.getToolCalls());
            ArrayList<OllamaMessage> messages = new ArrayList<OllamaMessage>(ollamaChatCompletion.getMessages());
            messages.add(responseMessage);
            for (ToolCall toolCall : toolCalls) {
                String functionName = toolCall.getFunction().getName();
                arguments = toolCall.getFunction().getArguments();
                String functionResponse = ToolUtil.invoke(functionName, arguments);
                OllamaMessage ollamaMessage = new OllamaMessage();
                ollamaMessage.setRole("tool");
                ollamaMessage.setContent(functionResponse);
                messages.add(ollamaMessage);
            }
            eventSourceListener.setToolCalls(new ArrayList<ToolCall>());
            eventSourceListener.setToolCall(null);
            ollamaChatCompletion.setMessages(messages);
        }
        chatCompletion.setMessages(this.ollamaMessagesToChatMessages(ollamaChatCompletion.getMessages()));
        chatCompletion.setTools(ollamaChatCompletion.getTools());
    }

    @Override
    public void chatCompletionStream(ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        this.chatCompletionStream(null, null, chatCompletion, eventSourceListener);
    }
}

