/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.openai.chat.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.lnyocly.ai4j.platform.openai.chat.serializer.ContentDeserializer;
import java.util.ArrayList;
import java.util.List;

@JsonDeserialize(using=ContentDeserializer.class)
public class Content {
    private String text;
    private List<MultiModal> multiModals;

    public static Content ofText(String text) {
        Content instance = new Content();
        instance.text = text;
        return instance;
    }

    public static Content ofMultiModals(List<MultiModal> parts) {
        Content instance = new Content();
        instance.multiModals = parts;
        return instance;
    }

    @JsonValue
    public Object toJson() {
        if (this.text != null) {
            return this.text;
        }
        if (this.multiModals != null) {
            return this.multiModals;
        }
        throw new IllegalStateException("Invalid content state");
    }

    public String getText() {
        return this.text;
    }

    public List<MultiModal> getMultiModals() {
        return this.multiModals;
    }

    public String toString() {
        return "Content(text=" + this.getText() + ", multiModals=" + this.getMultiModals() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class MultiModal {
        private String type = Type.access$000(Type.TEXT);
        private String text;
        @JsonProperty(value="image_url")
        private ImageUrl imageUrl;

        public static List<MultiModal> withMultiModal(String text, String ... imageUrl) {
            ArrayList<MultiModal> messages = new ArrayList<MultiModal>();
            messages.add(new MultiModal(Type.TEXT.getType(), text, null));
            for (String url : imageUrl) {
                messages.add(new MultiModal(Type.IMAGE_URL.getType(), null, new ImageUrl(url)));
            }
            return messages;
        }

        public static MultiModalBuilder builder() {
            return new MultiModalBuilder();
        }

        public String getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public ImageUrl getImageUrl() {
            return this.imageUrl;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="image_url")
        public void setImageUrl(ImageUrl imageUrl) {
            this.imageUrl = imageUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiModal)) {
                return false;
            }
            MultiModal other = (MultiModal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            ImageUrl this$imageUrl = this.getImageUrl();
            ImageUrl other$imageUrl = other.getImageUrl();
            return !(this$imageUrl == null ? other$imageUrl != null : !((Object)this$imageUrl).equals(other$imageUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MultiModal;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            ImageUrl $imageUrl = this.getImageUrl();
            result = result * 59 + ($imageUrl == null ? 43 : ((Object)$imageUrl).hashCode());
            return result;
        }

        public String toString() {
            return "Content.MultiModal(type=" + this.getType() + ", text=" + this.getText() + ", imageUrl=" + this.getImageUrl() + ")";
        }

        public MultiModal() {
        }

        public MultiModal(String type, String text, ImageUrl imageUrl) {
            this.type = type;
            this.text = text;
            this.imageUrl = imageUrl;
        }

        public static enum Type {
            TEXT("text", "\u6587\u672c\u7c7b\u578b"),
            IMAGE_URL("image_url", "\u56fe\u7247\u7c7b\u578b\uff0c\u53ef\u4ee5\u4e3aurl\u6216\u8005base64");

            private final String type;
            private final String info;

            public String getType() {
                return this.type;
            }

            public String getInfo() {
                return this.info;
            }

            private Type(String type, String info) {
                this.type = type;
                this.info = info;
            }

            static /* synthetic */ String access$000(Type x0) {
                return x0.type;
            }
        }

        public static class ImageUrl {
            private String url;

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ImageUrl)) {
                    return false;
                }
                ImageUrl other = (ImageUrl)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ImageUrl;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }

            public String toString() {
                return "Content.MultiModal.ImageUrl(url=" + this.getUrl() + ")";
            }

            public ImageUrl() {
            }

            public ImageUrl(String url) {
                this.url = url;
            }
        }

        public static class MultiModalBuilder {
            private String type;
            private String text;
            private ImageUrl imageUrl;

            MultiModalBuilder() {
            }

            public MultiModalBuilder type(String type) {
                this.type = type;
                return this;
            }

            public MultiModalBuilder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="image_url")
            public MultiModalBuilder imageUrl(ImageUrl imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public MultiModal build() {
                return new MultiModal(this.type, this.text, this.imageUrl);
            }

            public String toString() {
                return "Content.MultiModal.MultiModalBuilder(type=" + this.type + ", text=" + this.text + ", imageUrl=" + this.imageUrl + ")";
            }
        }
    }
}

