/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.openai.chat.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.Content;
import java.io.IOException;
import java.util.ArrayList;

public class ContentDeserializer
extends JsonDeserializer<Content> {
    public Content deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.isTextual()) {
            return Content.ofText(node.asText());
        }
        if (node.isArray()) {
            ArrayList<Content.MultiModal> parts = new ArrayList<Content.MultiModal>();
            for (JsonNode element : node) {
                Content.MultiModal part = (Content.MultiModal)p.getCodec().treeToValue((TreeNode)element, Content.MultiModal.class);
                parts.add(part);
            }
            return Content.ofMultiModals(parts);
        }
        throw new IOException("Unsupported content format");
    }
}

