/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.zhipu.chat.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ZhipuChatCompletion {
    @NonNull
    private String model;
    @NonNull
    private List<ChatMessage> messages;
    @JsonProperty(value="request_id")
    private String requestId;
    @JsonProperty(value="do_sample")
    private Boolean doSample = true;
    private Boolean stream = false;
    private Float temperature = Float.valueOf(0.95f);
    @JsonProperty(value="top_p")
    private Float topP = Float.valueOf(0.7f);
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    private List<String> stop;
    private List<Tool> tools;
    @JsonIgnore
    private List<String> functions;
    @JsonProperty(value="tool_choice")
    private String toolChoice;
    @JsonProperty(value="user_id")
    private String userId;

    public static ZhipuChatCompletionBuilder builder() {
        return new ZhipuChatCompletionBuilder();
    }

    public ZhipuChatCompletionBuilder toBuilder() {
        return new ZhipuChatCompletionBuilder().model(this.model).messages(this.messages).requestId(this.requestId).doSample(this.doSample).stream(this.stream).temperature(this.temperature).topP(this.topP).maxTokens(this.maxTokens).stop(this.stop).tools(this.tools).functions(this.functions).toolChoice(this.toolChoice).userId(this.userId);
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Boolean getDoSample() {
        return this.doSample;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public List<String> getFunctions() {
        return this.functions;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setMessages(@NonNull List<ChatMessage> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
    }

    @JsonProperty(value="request_id")
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @JsonProperty(value="do_sample")
    public void setDoSample(Boolean doSample) {
        this.doSample = doSample;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Float topP) {
        this.topP = topP;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    @JsonIgnore
    public void setFunctions(List<String> functions) {
        this.functions = functions;
    }

    @JsonProperty(value="tool_choice")
    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    @JsonProperty(value="user_id")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZhipuChatCompletion)) {
            return false;
        }
        ZhipuChatCompletion other = (ZhipuChatCompletion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$doSample = this.getDoSample();
        Boolean other$doSample = other.getDoSample();
        if (this$doSample == null ? other$doSample != null : !((Object)this$doSample).equals(other$doSample)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Float this$topP = this.getTopP();
        Float other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<ChatMessage> this$messages = this.getMessages();
        List<ChatMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        List<Tool> this$tools = this.getTools();
        List<Tool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        List<String> this$functions = this.getFunctions();
        List<String> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        String this$toolChoice = this.getToolChoice();
        String other$toolChoice = other.getToolChoice();
        if (this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZhipuChatCompletion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $doSample = this.getDoSample();
        result = result * 59 + ($doSample == null ? 43 : ((Object)$doSample).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Float $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<ChatMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        List<Tool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        List<String> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        String $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        return result;
    }

    public String toString() {
        return "ZhipuChatCompletion(model=" + this.getModel() + ", messages=" + this.getMessages() + ", requestId=" + this.getRequestId() + ", doSample=" + this.getDoSample() + ", stream=" + this.getStream() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", maxTokens=" + this.getMaxTokens() + ", stop=" + this.getStop() + ", tools=" + this.getTools() + ", functions=" + this.getFunctions() + ", toolChoice=" + this.getToolChoice() + ", userId=" + this.getUserId() + ")";
    }

    public ZhipuChatCompletion() {
    }

    public ZhipuChatCompletion(@NonNull String model, @NonNull List<ChatMessage> messages, String requestId, Boolean doSample, Boolean stream, Float temperature, Float topP, Integer maxTokens, List<String> stop, List<Tool> tools, List<String> functions, String toolChoice, String userId) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.model = model;
        this.messages = messages;
        this.requestId = requestId;
        this.doSample = doSample;
        this.stream = stream;
        this.temperature = temperature;
        this.topP = topP;
        this.maxTokens = maxTokens;
        this.stop = stop;
        this.tools = tools;
        this.functions = functions;
        this.toolChoice = toolChoice;
        this.userId = userId;
    }

    public static class ZhipuChatCompletionBuilder {
        private String model;
        private List<ChatMessage> messages;
        private String requestId;
        private Boolean doSample;
        private Boolean stream;
        private Float temperature;
        private Float topP;
        private Integer maxTokens;
        private List<String> stop;
        private List<Tool> tools;
        private String toolChoice;
        private String userId;
        private List<String> functions;

        public ZhipuChatCompletionBuilder functions(String ... functions) {
            if (this.functions == null) {
                this.functions = new ArrayList<String>();
            }
            this.functions.addAll(Arrays.asList(functions));
            return this;
        }

        public ZhipuChatCompletionBuilder functions(List<String> functions) {
            if (this.functions == null) {
                this.functions = new ArrayList<String>();
            }
            this.functions.addAll(functions);
            return this;
        }

        ZhipuChatCompletionBuilder() {
        }

        public ZhipuChatCompletionBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public ZhipuChatCompletionBuilder messages(@NonNull List<ChatMessage> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
            return this;
        }

        @JsonProperty(value="request_id")
        public ZhipuChatCompletionBuilder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="do_sample")
        public ZhipuChatCompletionBuilder doSample(Boolean doSample) {
            this.doSample = doSample;
            return this;
        }

        public ZhipuChatCompletionBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public ZhipuChatCompletionBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        public ZhipuChatCompletionBuilder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public ZhipuChatCompletionBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public ZhipuChatCompletionBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public ZhipuChatCompletionBuilder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        @JsonProperty(value="tool_choice")
        public ZhipuChatCompletionBuilder toolChoice(String toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        @JsonProperty(value="user_id")
        public ZhipuChatCompletionBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public ZhipuChatCompletion build() {
            return new ZhipuChatCompletion(this.model, this.messages, this.requestId, this.doSample, this.stream, this.temperature, this.topP, this.maxTokens, this.stop, this.tools, this.functions, this.toolChoice, this.userId);
        }

        public String toString() {
            return "ZhipuChatCompletion.ZhipuChatCompletionBuilder(model=" + this.model + ", messages=" + this.messages + ", requestId=" + this.requestId + ", doSample=" + this.doSample + ", stream=" + this.stream + ", temperature=" + this.temperature + ", topP=" + this.topP + ", maxTokens=" + this.maxTokens + ", stop=" + this.stop + ", tools=" + this.tools + ", functions=" + this.functions + ", toolChoice=" + this.toolChoice + ", userId=" + this.userId + ")";
        }
    }
}

