/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.service;

public enum PlatformType {
    OPENAI("openai"),
    ZHIPU("zhipu"),
    DEEPSEEK("deepseek"),
    MOONSHOT("moonshot"),
    HUNYUAN("hunyuan"),
    LINGYI("lingyi"),
    OLLAMA("ollama"),
    MINIMAX("minimax"),
    BAICHUAN("baichuan");

    private final String platform;

    public static PlatformType getPlatform(String value) {
        String target = value.toLowerCase();
        for (PlatformType platformType : PlatformType.values()) {
            if (!platformType.getPlatform().equals(target)) continue;
            return platformType;
        }
        return OPENAI;
    }

    private PlatformType(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }
}

