/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.utils;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLoaderUtil {
    private static final Logger log = LoggerFactory.getLogger(ServiceLoaderUtil.class);

    public static <T> T load(Class<T> service) {
        ServiceLoader<T> loader = ServiceLoader.load(service);
        Iterator<T> iterator = loader.iterator();
        if (iterator.hasNext()) {
            T impl = iterator.next();
            log.info("Loaded SPI implementation: {}", (Object)impl.getClass().getSimpleName());
            return impl;
        }
        throw new IllegalStateException("No implementation found for " + service.getName());
    }
}

