/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.dynamic.BatchExecutableCommand;
import io.lettuce.core.dynamic.Batcher;
import io.lettuce.core.dynamic.CommandFactory;
import io.lettuce.core.dynamic.CommandMethod;
import io.lettuce.core.dynamic.CommandMethodVerifier;
import io.lettuce.core.dynamic.ExecutableCommand;
import io.lettuce.core.dynamic.ExecutableCommandLookupStrategySupport;
import io.lettuce.core.dynamic.RedisCommandsMetadata;
import io.lettuce.core.dynamic.batch.BatchExecutor;
import io.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import io.lettuce.core.dynamic.parameter.ExecutionSpecificParameters;
import io.lettuce.core.internal.LettuceAssert;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;

class BatchExecutableCommandLookupStrategy
extends ExecutableCommandLookupStrategySupport {
    private final Set<Class<?>> SYNCHRONOUS_RETURN_TYPES = new HashSet<Class>(Arrays.asList(Void.class, Void.TYPE));
    private final Batcher batcher;
    private final StatefulConnection<Object, Object> connection;

    public BatchExecutableCommandLookupStrategy(List<RedisCodec<?, ?>> redisCodecs, CommandOutputFactoryResolver commandOutputFactoryResolver, CommandMethodVerifier commandMethodVerifier, Batcher batcher, StatefulConnection<Object, Object> connection) {
        super(redisCodecs, commandOutputFactoryResolver, commandMethodVerifier);
        this.batcher = batcher;
        this.connection = connection;
    }

    public static boolean supports(CommandMethod method) {
        return method.isBatchExecution() || BatchExecutableCommandLookupStrategy.isForceFlush(method);
    }

    private static boolean isForceFlush(CommandMethod method) {
        return method.getName().equals("flush") && method.getMethod().getDeclaringClass().equals(BatchExecutor.class);
    }

    @Override
    public ExecutableCommand resolveCommandMethod(final CommandMethod method, RedisCommandsMetadata metadata) {
        LettuceAssert.isTrue(!method.isReactiveExecution(), () -> String.format("Command method %s not supported by this command lookup strategy", method));
        ExecutionSpecificParameters parameters = (ExecutionSpecificParameters)method.getParameters();
        if (parameters.hasTimeoutIndex()) {
            throw new IllegalArgumentException(String.format("Timeout and batching is not supported, offending command method %s ", method));
        }
        if (BatchExecutableCommandLookupStrategy.isForceFlush(method)) {
            return new ExecutableCommand(){

                @Override
                public Object execute(Object[] parameters) throws ExecutionException, InterruptedException {
                    BatchExecutableCommand.synchronize(BatchExecutableCommandLookupStrategy.this.batcher.flush(), BatchExecutableCommandLookupStrategy.this.connection);
                    return null;
                }

                @Override
                public CommandMethod getCommandMethod() {
                    return method;
                }
            };
        }
        if (method.isFutureExecution() || this.SYNCHRONOUS_RETURN_TYPES.contains(method.getReturnType().getRawClass())) {
            CommandFactory commandFactory = super.resolveCommandFactory(method, metadata);
            return new BatchExecutableCommand(method, commandFactory, this.batcher, this.connection);
        }
        throw new IllegalArgumentException(String.format("Batching command method %s must declare either a Future or void return type", method));
    }
}

