/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.atlas;

import com.netflix.spectator.api.AbstractMeter;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.Collections;
import java.util.function.ToDoubleFunction;

class SpectatorToDoubleGauge<T>
extends AbstractMeter<T>
implements Gauge {
    private final ToDoubleFunction<T> f;

    SpectatorToDoubleGauge(Clock clock, Id id, T obj, ToDoubleFunction<T> f) {
        super(clock, id, obj);
        this.f = f;
    }

    public Iterable<Measurement> measure() {
        return Collections.singleton(new Measurement(this.id, this.clock.wallTime(), this.value()));
    }

    public double value() {
        Object obj = this.ref.get();
        return obj == null ? Double.NaN : this.f.applyAsDouble(obj);
    }
}

