/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.ganglia;

import info.ganglia.gmetric4j.gmetric.GMetric;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import java.util.concurrent.TimeUnit;

public interface GangliaConfig
extends DropwizardConfig {
    public static final GangliaConfig DEFAULT = k -> null;

    public String get(String var1);

    default public String prefix() {
        return "ganglia";
    }

    default public TimeUnit rateUnits() {
        String v = this.get(this.prefix() + ".rateUnits");
        return v == null ? TimeUnit.SECONDS : TimeUnit.valueOf(v.toUpperCase());
    }

    default public TimeUnit durationUnits() {
        String v = this.get(this.prefix() + ".durationUnits");
        return v == null ? TimeUnit.MILLISECONDS : TimeUnit.valueOf(v.toUpperCase());
    }

    default public String protocolVersion() {
        String v = this.get(this.prefix() + ".protocolVersion");
        if (v == null) {
            return "3.1";
        }
        if (!v.equals("3.1") && !v.equals("3.0")) {
            throw new IllegalArgumentException("Ganglia version must be one of 3.1 or 3.0 (check property " + this.prefix() + ".protocolVersion)");
        }
        return v;
    }

    default public GMetric.UDPAddressingMode addressingMode() {
        String v = this.get(this.prefix() + ".addressingMode");
        if (v == null) {
            return GMetric.UDPAddressingMode.MULTICAST;
        }
        if (!v.equalsIgnoreCase("unicast") && !v.equalsIgnoreCase("multicast")) {
            throw new IllegalArgumentException("Ganglia UDP addressing mode must be one of 'unicast' or 'multicast' (check property " + this.prefix() + ".addressingMode)");
        }
        return GMetric.UDPAddressingMode.valueOf((String)v.toUpperCase());
    }

    default public int ttl() {
        String v = this.get(this.prefix() + ".ttl");
        return v == null ? 1 : Integer.parseInt(v);
    }

    default public String host() {
        String v = this.get(this.prefix() + ".host");
        return v == null ? "localhost" : v;
    }

    default public int port() {
        String v = this.get(this.prefix() + ".port");
        return v == null ? 8649 : Integer.parseInt(v);
    }

    default public boolean enabled() {
        String v = this.get(this.prefix() + ".enabled");
        return v == null || Boolean.valueOf(v) != false;
    }
}

