/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.influx;

import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.influx.InfluxConsistency;

public interface InfluxConfig
extends StepRegistryConfig {
    public static final InfluxConfig DEFAULT = k -> null;

    default public String prefix() {
        return "influx";
    }

    default public String db() {
        String v = this.get(this.prefix() + ".db");
        return v == null ? "mydb" : v;
    }

    default public InfluxConsistency consistency() {
        String v = this.get(this.prefix() + ".consistency");
        if (v == null) {
            return InfluxConsistency.ONE;
        }
        return InfluxConsistency.valueOf(v.toUpperCase());
    }

    default public String userName() {
        return this.get(this.prefix() + ".userName");
    }

    default public String password() {
        return this.get(this.prefix() + ".password");
    }

    default public String retentionPolicy() {
        return this.get(this.prefix() + ".retentionPolicy");
    }

    default public String uri() {
        String v = this.get(this.prefix() + ".uri");
        return v == null ? "http://localhost:8086" : v;
    }

    default public boolean compressed() {
        String v = this.get(this.prefix() + ".compressed");
        return v == null || Boolean.valueOf(v) != false;
    }
}

