/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.influx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.ValueAtPercentile;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.influx.InfluxConfig;
import io.micrometer.influx.InfluxNamingConvention;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxMeterRegistry
extends StepMeterRegistry {
    private final InfluxConfig config;
    private final Logger logger = LoggerFactory.getLogger(InfluxMeterRegistry.class);
    private final DecimalFormat format = new DecimalFormat("#.####", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public InfluxMeterRegistry(InfluxConfig config, Clock clock) {
        super((StepRegistryConfig)config, clock);
        this.config().namingConvention((NamingConvention)new InfluxNamingConvention(NamingConvention.snakeCase));
        this.config = config;
        this.start();
    }

    public InfluxMeterRegistry(InfluxConfig config) {
        this(config, Clock.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDatabaseIfNecessary() {
        HttpURLConnection con = null;
        try {
            URL queryEndpoint = URI.create(this.config.uri() + "/query?q=" + URLEncoder.encode("CREATE DATABASE \"" + this.config.db() + "\"", "UTF-8")).toURL();
            con = (HttpURLConnection)queryEndpoint.openConnection();
            con.setConnectTimeout((int)this.config.connectTimeout().toMillis());
            con.setReadTimeout((int)this.config.readTimeout().toMillis());
            con.setRequestMethod("POST");
            int status = con.getResponseCode();
            if (status >= 200 && status < 300) {
                this.logger.debug("influx database {} is ready to receive metrics", (Object)this.config.db());
            } else if (status >= 400) {
                try (InputStream in = con.getErrorStream();){
                    this.logger.error("unable to create database '{}': {}", (Object)this.config.db(), (Object)new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n")));
                }
            }
            this.quietlyCloseUrlConnection(con);
        }
        catch (IOException e) {
            this.logger.warn("unable to create database '{}'", (Object)this.config.db(), (Object)e);
        }
        finally {
            this.quietlyCloseUrlConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish() {
        this.createDatabaseIfNecessary();
        try {
            String write = "/write?consistency=" + this.config.consistency().toString().toLowerCase() + "&precision=ms&db=" + this.config.db();
            if (this.config.retentionPolicy() != null) {
                write = write + "&rp=" + this.config.retentionPolicy();
            }
            URL influxEndpoint = URI.create(this.config.uri() + write).toURL();
            HttpURLConnection con = null;
            for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
                try {
                    con = (HttpURLConnection)influxEndpoint.openConnection();
                    con.setConnectTimeout((int)this.config.connectTimeout().toMillis());
                    con.setReadTimeout((int)this.config.readTimeout().toMillis());
                    con.setRequestMethod("POST");
                    con.setRequestProperty("Content-Type", "plain/text");
                    con.setDoOutput(true);
                    if (this.config.userName() != null && this.config.password() != null) {
                        String encoded = Base64.getEncoder().encodeToString((this.config.userName() + ":" + this.config.password()).getBytes(StandardCharsets.UTF_8));
                        con.setRequestProperty("Authorization", "Basic " + encoded);
                    }
                    List bodyLines = batch.stream().map(m -> {
                        if (m instanceof Timer) {
                            return this.writeTimer((Timer)m);
                        }
                        if (m instanceof DistributionSummary) {
                            return this.writeSummary((DistributionSummary)m);
                        }
                        if (m instanceof FunctionTimer) {
                            return this.writeTimer((FunctionTimer)m);
                        }
                        if (m instanceof TimeGauge) {
                            return this.writeGauge(m.getId(), ((TimeGauge)m).value(this.getBaseTimeUnit()));
                        }
                        if (m instanceof Gauge) {
                            return this.writeGauge(m.getId(), ((Gauge)m).value());
                        }
                        if (m instanceof FunctionCounter) {
                            return this.writeCounter(m.getId(), ((FunctionCounter)m).count());
                        }
                        if (m instanceof Counter) {
                            return this.writeCounter(m.getId(), ((Counter)m).count());
                        }
                        if (m instanceof LongTaskTimer) {
                            return this.writeLongTaskTimer((LongTaskTimer)m);
                        }
                        return this.writeMeter((Meter)m);
                    }).collect(Collectors.toList());
                    String body = String.join((CharSequence)"\n", bodyLines);
                    if (this.config.compressed()) {
                        con.setRequestProperty("Content-Encoding", "gzip");
                    }
                    try (OutputStream os = con.getOutputStream();){
                        if (this.config.compressed()) {
                            try (GZIPOutputStream gz = new GZIPOutputStream(os);){
                                gz.write(body.getBytes());
                                gz.flush();
                            }
                        } else {
                            os.write(body.getBytes());
                        }
                        os.flush();
                    }
                    int status = con.getResponseCode();
                    if (status >= 200 && status < 300) {
                        this.logger.info("successfully sent {} metrics to influx", (Object)batch.size());
                        continue;
                    }
                    if (status >= 400) {
                        InputStream in = con.getErrorStream();
                        Throwable throwable = null;
                        try {
                            this.logger.error("failed to send metrics: " + new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n")));
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            in.close();
                            continue;
                        }
                    }
                    this.logger.error("failed to send metrics: http " + status);
                }
                finally {
                    this.quietlyCloseUrlConnection(con);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed InfluxDB publishing endpoint, see '" + this.config.prefix() + ".uri'", e);
        }
        catch (IOException e) {
            this.logger.warn("failed to send metrics", (Throwable)e);
        }
    }

    private void quietlyCloseUrlConnection(HttpURLConnection con) {
        if (con == null) {
            return;
        }
        try {
            con.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String writeMeter(Meter m) {
        Stream.Builder<Field> fields = Stream.builder();
        for (Measurement measurement : m.measure()) {
            String fieldKey = measurement.getStatistic().toString().replaceAll("(.)(\\p{Upper})", "$1_$2").toLowerCase();
            fields.add(new Field(fieldKey, measurement.getValue()));
        }
        return this.influxLineProtocol(m.getId(), "unknown", fields.build(), this.clock.wallTime());
    }

    private String writeLongTaskTimer(LongTaskTimer timer) {
        Stream<Field> fields = Stream.of(new Field("active_tasks", timer.activeTasks()), new Field("duration", timer.duration(this.getBaseTimeUnit())));
        return this.influxLineProtocol(timer.getId(), "long_task_timer", fields, this.clock.wallTime());
    }

    private String writeCounter(Meter.Id id, double count) {
        return this.influxLineProtocol(id, "counter", Stream.of(new Field("value", count)), this.clock.wallTime());
    }

    private String writeGauge(Meter.Id id, double value) {
        return this.influxLineProtocol(id, "gauge", Stream.of(new Field("value", value)), this.clock.wallTime());
    }

    private String writeTimer(FunctionTimer timer) {
        Stream<Field> fields = Stream.of(new Field("sum", timer.totalTime(this.getBaseTimeUnit())), new Field("count", timer.count()), new Field("mean", timer.mean(this.getBaseTimeUnit())));
        return this.influxLineProtocol(timer.getId(), "histogram", fields, this.clock.wallTime());
    }

    private String writeTimer(Timer timer) {
        HistogramSnapshot snapshot = timer.takeSnapshot(false);
        Stream.Builder<Field> fields = Stream.builder();
        fields.add(new Field("sum", snapshot.total(this.getBaseTimeUnit())));
        fields.add(new Field("count", snapshot.count()));
        fields.add(new Field("mean", snapshot.mean(this.getBaseTimeUnit())));
        fields.add(new Field("upper", snapshot.max(this.getBaseTimeUnit())));
        for (ValueAtPercentile v : snapshot.percentileValues()) {
            fields.add(new Field(this.format.format(v.percentile()) + "_percentile", v.value(this.getBaseTimeUnit())));
        }
        return this.influxLineProtocol(timer.getId(), "histogram", fields.build(), this.clock.wallTime());
    }

    private String writeSummary(DistributionSummary summary) {
        HistogramSnapshot snapshot = summary.takeSnapshot(false);
        Stream.Builder<Field> fields = Stream.builder();
        fields.add(new Field("sum", snapshot.total()));
        fields.add(new Field("count", snapshot.count()));
        fields.add(new Field("mean", snapshot.mean()));
        fields.add(new Field("upper", snapshot.max()));
        for (ValueAtPercentile v : snapshot.percentileValues()) {
            fields.add(new Field(this.format.format(v.percentile()) + "_percentile", v.value()));
        }
        return this.influxLineProtocol(summary.getId(), "histogram", fields.build(), this.clock.wallTime());
    }

    private String influxLineProtocol(Meter.Id id, String metricType, Stream<Field> fields, long time) {
        String tags = this.getConventionTags(id).stream().map(t -> "," + t.getKey() + "=" + t.getValue()).collect(Collectors.joining(""));
        return this.getConventionName(id) + tags + ",metric_type=" + metricType + " " + fields.map(Field::toString).collect(Collectors.joining(",")) + " " + time;
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    class Field {
        final String key;
        final double value;

        Field(String key, double value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "=" + InfluxMeterRegistry.this.format.format(this.value);
        }
    }
}

