/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.StatsdPollable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import org.reactivestreams.Subscriber;

public class StatsdFunctionTimer<T>
extends CumulativeFunctionTimer<T>
implements StatsdPollable {
    private final StatsdLineBuilder lineBuilder;
    private final Subscriber<String> publisher;
    private final AtomicReference<Long> lastCount = new AtomicReference<Long>(0L);
    private final AtomicReference<Double> lastTime = new AtomicReference<Double>(0.0);

    StatsdFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits, TimeUnit baseTimeUnit, StatsdLineBuilder lineBuilder, Subscriber<String> publisher) {
        super(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits, baseTimeUnit);
        this.lineBuilder = lineBuilder;
        this.publisher = publisher;
    }

    @Override
    public void poll() {
        this.lastCount.updateAndGet(prevCount -> {
            long count = (long)this.count();
            long newTimingsCount = count - prevCount;
            if (newTimingsCount > 0L) {
                this.lastTime.updateAndGet(prevTime -> {
                    double totalTime = this.totalTime(TimeUnit.MILLISECONDS);
                    double newTimingsSum = totalTime - prevTime;
                    double timingAverage = newTimingsSum / (double)newTimingsCount;
                    int i = 0;
                    while ((long)i < newTimingsCount) {
                        this.publisher.onNext((Object)this.lineBuilder.timing(timingAverage));
                        ++i;
                    }
                    return totalTime;
                });
            }
            return count;
        });
    }
}

