/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.StatsdPollable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;

public class StatsdLongTaskTimer
extends DefaultLongTaskTimer
implements StatsdPollable {
    private final StatsdLineBuilder lineBuilder;
    private final Subscriber<String> publisher;
    private final AtomicReference<Long> lastActive = new AtomicReference<Long>(Long.MIN_VALUE);
    private final AtomicReference<Double> lastDuration = new AtomicReference<Double>(Double.NEGATIVE_INFINITY);

    StatsdLongTaskTimer(Meter.Id id, StatsdLineBuilder lineBuilder, Subscriber<String> publisher, Clock clock) {
        super(id, clock);
        this.lineBuilder = lineBuilder;
        this.publisher = publisher;
    }

    @Override
    public void poll() {
        double duration;
        long active = this.activeTasks();
        if (this.lastActive.getAndSet(active) != active) {
            this.publisher.onNext((Object)this.lineBuilder.gauge(active, Statistic.ActiveTasks));
        }
        if (this.lastDuration.getAndSet(duration = this.duration(TimeUnit.MILLISECONDS)) != duration) {
            this.publisher.onNext((Object)this.lineBuilder.gauge(duration, Statistic.Duration));
        }
    }
}

