/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.FluxOperator;
import io.micrometer.shaded.reactor.core.publisher.InnerOperator;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.publisher.SerializedSubscriber;
import io.micrometer.shaded.reactor.core.scheduler.Scheduler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class FluxDelaySequence<T>
extends FluxOperator<T, T> {
    final Duration delay;
    final Scheduler scheduler;

    FluxDelaySequence(Flux<T> source, Duration delay, Scheduler scheduler) {
        super(source);
        this.delay = delay;
        this.scheduler = scheduler;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Scheduler.Worker w = this.scheduler.createWorker();
        this.source.subscribe(new DelaySubscriber<T>(actual, this.delay, w));
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_ON) {
            return this.scheduler;
        }
        return super.scanUnsafe(key);
    }

    static final class DelaySubscriber<T>
    implements InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final long delay;
        final TimeUnit timeUnit;
        final Scheduler.Worker w;
        Subscription s;
        volatile boolean done;
        volatile long delayed;
        static final AtomicLongFieldUpdater<DelaySubscriber> DELAYED = AtomicLongFieldUpdater.newUpdater(DelaySubscriber.class, "delayed");

        DelaySubscriber(CoreSubscriber<? super T> actual, Duration delay, Scheduler.Worker w) {
            this.actual = new SerializedSubscriber<T>(actual);
            this.w = w;
            if (delay.compareTo(Duration.ofMinutes(1L)) < 0) {
                this.delay = delay.toNanos();
                this.timeUnit = TimeUnit.NANOSECONDS;
            } else {
                this.delay = delay.toMillis();
                this.timeUnit = TimeUnit.MILLISECONDS;
            }
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done || this.delayed < 0L) {
                Operators.onNextDropped(t, this.currentContext());
                return;
            }
            DELAYED.incrementAndGet(this);
            this.w.schedule(() -> this.delayedNext(t), this.delay, this.timeUnit);
        }

        private void delayedNext(T t) {
            DELAYED.decrementAndGet(this);
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.currentContext());
                return;
            }
            this.done = true;
            if (DELAYED.compareAndSet(this, 0L, -1L)) {
                this.actual.onError(t);
            } else {
                this.w.schedule(new OnError(t), this.delay, this.timeUnit);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (DELAYED.compareAndSet(this, 0L, -1L)) {
                this.actual.onComplete();
            } else {
                this.w.schedule(new OnComplete(), this.delay, this.timeUnit);
            }
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
            this.w.dispose();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.RUN_ON) {
                return this.w;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.w.isDisposed() && !this.done;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        final class OnComplete
        implements Runnable {
            OnComplete() {
            }

            @Override
            public void run() {
                try {
                    DelaySubscriber.this.actual.onComplete();
                }
                finally {
                    DelaySubscriber.this.w.dispose();
                }
            }
        }

        final class OnError
        implements Runnable {
            private final Throwable t;

            OnError(Throwable t) {
                this.t = t;
            }

            @Override
            public void run() {
                try {
                    DelaySubscriber.this.actual.onError(this.t);
                }
                finally {
                    DelaySubscriber.this.w.dispose();
                }
            }
        }
    }
}

