/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.DirectProcessor;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.FluxOperator;
import io.micrometer.shaded.reactor.core.publisher.InnerConsumer;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.context.Context;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import java.util.stream.Stream;

final class FluxRetryWhen<T>
extends FluxOperator<T, T> {
    final Function<? super Flux<Throwable>, ? extends Publisher<?>> whenSourceFactory;

    FluxRetryWhen(Flux<? extends T> source, Function<? super Flux<Throwable>, ? extends Publisher<?>> whenSourceFactory) {
        super(source);
        this.whenSourceFactory = Objects.requireNonNull(whenSourceFactory, "whenSourceFactory");
    }

    static <T> void subscribe(CoreSubscriber<? super T> s, Function<? super Flux<Throwable>, ? extends Publisher<?>> whenSourceFactory, Publisher<? extends T> source) {
        Publisher<?> p;
        RetryWhenOtherSubscriber other = new RetryWhenOtherSubscriber();
        CoreSubscriber<Throwable> signaller = Operators.serialize(other.completionSignal);
        signaller.onSubscribe(Operators.emptySubscription());
        CoreSubscriber<T> serial = Operators.serialize(s);
        RetryWhenMainSubscriber<? extends T> main = new RetryWhenMainSubscriber<T>(serial, signaller, source);
        other.main = main;
        serial.onSubscribe(main);
        try {
            p = Objects.requireNonNull(whenSourceFactory.apply(other), "The whenSourceFactory returned a null Publisher");
        }
        catch (Throwable e) {
            s.onError(Operators.onOperatorError(e, s.currentContext()));
            return;
        }
        p.subscribe(other);
        if (!main.cancelled) {
            source.subscribe(main);
        }
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        FluxRetryWhen.subscribe(actual, this.whenSourceFactory, this.source);
    }

    static final class RetryWhenOtherSubscriber
    extends Flux<Throwable>
    implements InnerConsumer<Object> {
        RetryWhenMainSubscriber<?> main;
        final DirectProcessor<Throwable> completionSignal = new DirectProcessor();

        RetryWhenOtherSubscriber() {
        }

        @Override
        public Context currentContext() {
            return this.main.currentContext();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.main.otherArbiter;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.main;
            }
            return null;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.main.setWhen(s);
        }

        @Override
        public void onNext(Object t) {
            this.main.resubscribe(t);
        }

        @Override
        public void onError(Throwable t) {
            this.main.whenError(t);
        }

        @Override
        public void onComplete() {
            this.main.whenComplete();
        }

        @Override
        public void subscribe(CoreSubscriber<? super Throwable> actual) {
            this.completionSignal.subscribe(actual);
        }
    }

    static final class RetryWhenMainSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Operators.DeferredSubscription otherArbiter;
        final Subscriber<Throwable> signaller;
        final Publisher<? extends T> source;
        Context context;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<RetryWhenMainSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(RetryWhenMainSubscriber.class, "wip");
        long produced;

        RetryWhenMainSubscriber(CoreSubscriber<? super T> actual, Subscriber<Throwable> signaller, Publisher<? extends T> source) {
            super(actual);
            this.signaller = signaller;
            this.source = source;
            this.otherArbiter = new Operators.DeferredSubscription();
            this.context = actual.currentContext();
        }

        @Override
        public Context currentContext() {
            return this.context;
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(Scannable.from(this.signaller), this.otherArbiter);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.otherArbiter.cancel();
                super.cancel();
            }
        }

        public void setWhen(Subscription w) {
            this.otherArbiter.set(w);
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
            ++this.produced;
        }

        @Override
        public void onError(Throwable t) {
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.otherArbiter.request(1L);
            this.signaller.onNext(t);
        }

        @Override
        public void onComplete() {
            this.otherArbiter.cancel();
            this.actual.onComplete();
        }

        void resubscribe(Object trigger) {
            if (WIP.getAndIncrement(this) == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    if (trigger instanceof Context) {
                        this.context = (Context)trigger;
                    }
                    this.source.subscribe(this);
                } while (WIP.decrementAndGet(this) != 0);
            }
        }

        void whenError(Throwable e) {
            super.cancel();
            this.actual.onError(e);
        }

        void whenComplete() {
            super.cancel();
            this.actual.onComplete();
        }
    }
}

