/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.publisher.FluxFromMonoOperator;
import io.micrometer.shaded.reactor.core.publisher.FluxRepeat;
import io.micrometer.shaded.reactor.core.publisher.Mono;

final class MonoRepeat<T>
extends FluxFromMonoOperator<T, T> {
    final long times;

    MonoRepeat(Mono<? extends T> source, long times) {
        super(source);
        if (times <= 0L) {
            throw new IllegalArgumentException("times > 0 required");
        }
        this.times = times;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        FluxRepeat.RepeatSubscriber<T> parent = new FluxRepeat.RepeatSubscriber<T>(this.source, actual, this.times);
        actual.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.onComplete();
        }
    }
}

