/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;

final class MonoRunnable<T>
extends Mono<T>
implements Callable<Void> {
    final Runnable run;

    MonoRunnable(Runnable run) {
        this.run = Objects.requireNonNull(run, "run");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        try {
            this.run.run();
        }
        catch (Throwable ex) {
            Operators.error(actual, Operators.onOperatorError(ex, actual.currentContext()));
            return;
        }
        Operators.complete(actual);
    }

    @Override
    @Nullable
    public T block(Duration m) {
        this.run.run();
        return null;
    }

    @Override
    @Nullable
    public T block() {
        this.run.run();
        return null;
    }

    @Override
    @Nullable
    public Void call() throws Exception {
        this.run.run();
        return null;
    }
}

