/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.FluxTimeout;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoOperator;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import java.util.Objects;
import java.util.function.Function;

final class MonoTimeout<T, U, V>
extends MonoOperator<T, T> {
    final Publisher<U> firstTimeout;
    final Publisher<? extends T> other;
    final String timeoutDescription;
    static final Function NEVER = e -> Flux.never();

    MonoTimeout(Mono<? extends T> source, Publisher<U> firstTimeout, String timeoutDescription) {
        super(source);
        this.firstTimeout = Objects.requireNonNull(firstTimeout, "firstTimeout");
        this.other = null;
        this.timeoutDescription = timeoutDescription;
    }

    MonoTimeout(Mono<? extends T> source, Publisher<U> firstTimeout, Publisher<? extends T> other) {
        super(source);
        this.firstTimeout = Objects.requireNonNull(firstTimeout, "firstTimeout");
        this.other = Objects.requireNonNull(other, "other");
        this.timeoutDescription = null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        CoreSubscriber<T> serial = Operators.serialize(actual);
        FluxTimeout.TimeoutMainSubscriber main = new FluxTimeout.TimeoutMainSubscriber(serial, NEVER, this.other, this.timeoutDescription);
        serial.onSubscribe(main);
        FluxTimeout.TimeoutTimeoutSubscriber ts = new FluxTimeout.TimeoutTimeoutSubscriber(main, 0L);
        main.setTimeout(ts);
        this.firstTimeout.subscribe(ts);
        this.source.subscribe(main);
    }
}

