/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.channel;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.io.netty.handler.logging.LoggingHandler;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.MonoSink;
import io.micrometer.shaded.reactor.ipc.netty.FutureMono;
import io.micrometer.shaded.reactor.ipc.netty.NettyContext;
import io.micrometer.shaded.reactor.ipc.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.ipc.netty.channel.ContextHandler;
import io.micrometer.shaded.reactor.ipc.netty.options.NettyOptions;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Objects;

abstract class CloseableContextHandler<CHANNEL extends Channel>
extends ContextHandler<CHANNEL>
implements ChannelFutureListener {
    static final Logger log = Loggers.getLogger(CloseableContextHandler.class);
    ChannelFuture f;

    CloseableContextHandler(ChannelOperations.OnNew<CHANNEL> channelOpFactory, NettyOptions<?, ?> options, MonoSink<NettyContext> sink, LoggingHandler loggingHandler, SocketAddress providedAddress) {
        super(channelOpFactory, options, sink, loggingHandler, providedAddress);
    }

    @Override
    protected Publisher<Void> onCloseOrRelease(Channel channel) {
        return FutureMono.from(channel.closeFuture());
    }

    @Override
    public final void operationComplete(ChannelFuture f) throws Exception {
        if (!f.isSuccess()) {
            if (f.isCancelled()) {
                log.debug("Cancelled {}", f.channel().toString());
                return;
            }
            if (f.cause() != null) {
                this.sink.error(f.cause());
            } else {
                this.sink.error(new IOException("error while connecting to " + f.channel().toString()));
            }
        } else {
            this.doStarted(f.channel());
        }
    }

    @Override
    public final void setFuture(Future<?> future) {
        Objects.requireNonNull(future, "future");
        if (this.f != null) {
            future.cancel(true);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Connecting new channel: {}", future.toString());
        }
        this.f = (ChannelFuture)future;
        if (future.isDone()) {
            try {
                this.operationComplete((ChannelFuture)future);
            }
            catch (Exception e) {
                this.fireContextError(e);
            }
            return;
        }
        this.f.addListener(this);
    }

    @Override
    public final void dispose() {
        if (this.f == null) {
            return;
        }
        if (this.f.channel().isActive()) {
            this.f.channel().close();
        } else if (!this.f.isDone()) {
            this.f.cancel(true);
        }
    }
}

