/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http.client;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocator;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.socket.SocketChannel;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpConstants;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMessage;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMethod;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpUtil;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpVersion;
import io.micrometer.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.micrometer.shaded.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.micrometer.shaded.io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.micrometer.shaded.io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.micrometer.shaded.io.netty.handler.stream.ChunkedWriteHandler;
import io.micrometer.shaded.io.netty.util.AttributeKey;
import io.micrometer.shaded.io.netty.util.ReferenceCountUtil;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.ipc.netty.FutureMono;
import io.micrometer.shaded.reactor.ipc.netty.NettyContext;
import io.micrometer.shaded.reactor.ipc.netty.NettyOutbound;
import io.micrometer.shaded.reactor.ipc.netty.channel.ContextHandler;
import io.micrometer.shaded.reactor.ipc.netty.http.Cookies;
import io.micrometer.shaded.reactor.ipc.netty.http.HttpOperations;
import io.micrometer.shaded.reactor.ipc.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.ipc.netty.http.client.HttpClientException;
import io.micrometer.shaded.reactor.ipc.netty.http.client.HttpClientFormEncoder;
import io.micrometer.shaded.reactor.ipc.netty.http.client.HttpClientRequest;
import io.micrometer.shaded.reactor.ipc.netty.http.client.HttpClientResponse;
import io.micrometer.shaded.reactor.ipc.netty.http.client.HttpClientWSOperations;
import io.micrometer.shaded.reactor.ipc.netty.http.client.RedirectClientException;
import io.micrometer.shaded.reactor.ipc.netty.http.websocket.WebsocketInbound;
import io.micrometer.shaded.reactor.ipc.netty.http.websocket.WebsocketOutbound;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;

class HttpClientOperations
extends HttpOperations<HttpClientResponse, HttpClientRequest>
implements HttpClientResponse,
HttpClientRequest {
    final String[] redirectedFrom;
    final boolean isSecure;
    final HttpRequest nettyRequest;
    final HttpHeaders requestHeaders;
    volatile ResponseState responseState;
    int inboundPrefetch;
    boolean started;
    boolean clientError = true;
    boolean serverError = true;
    boolean redirectable;
    static final int MAX_REDIRECTS = 50;
    static final String[] EMPTY_REDIRECTIONS = new String[0];
    static final Logger log = Loggers.getLogger(HttpClientOperations.class);
    static final AttributeKey<String[]> REDIRECT_ATTR_KEY = AttributeKey.newInstance("httpRedirects");

    static HttpOperations bindHttp(Channel channel, BiFunction<? super HttpClientResponse, ? super HttpClientRequest, ? extends Publisher<Void>> handler, ContextHandler<?> context) {
        return new HttpClientOperations(channel, handler, context);
    }

    HttpClientOperations(Channel channel, HttpClientOperations replaced) {
        super(channel, replaced);
        this.started = replaced.started;
        this.redirectedFrom = replaced.redirectedFrom;
        this.isSecure = replaced.isSecure;
        this.nettyRequest = replaced.nettyRequest;
        this.responseState = replaced.responseState;
        this.redirectable = replaced.redirectable;
        this.inboundPrefetch = replaced.inboundPrefetch;
        this.requestHeaders = replaced.requestHeaders;
        this.clientError = replaced.clientError;
        this.serverError = replaced.serverError;
    }

    HttpClientOperations(Channel channel, BiFunction<? super HttpClientResponse, ? super HttpClientRequest, ? extends Publisher<Void>> handler, ContextHandler<?> context) {
        super(channel, handler, context);
        this.isSecure = channel.pipeline().get("io.micrometer.shaded.reactor.left.sslHandler") != null;
        String[] redirects = channel.attr(REDIRECT_ATTR_KEY).get();
        this.redirectedFrom = redirects == null ? EMPTY_REDIRECTIONS : redirects;
        this.nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        this.requestHeaders = this.nettyRequest.headers();
        this.requestHeaders.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)HttpClient.USER_AGENT);
        this.inboundPrefetch = 16;
        this.chunkedTransfer(true);
    }

    @Override
    public HttpClientRequest addCookie(Cookie cookie) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.add((CharSequence)HttpHeaderNames.COOKIE, (Object)ClientCookieEncoder.STRICT.encode(cookie));
        return this;
    }

    @Override
    public HttpClientOperations addHandlerLast(ChannelHandler handler) {
        super.addHandlerLast(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerLast(String name, ChannelHandler handler) {
        super.addHandlerLast(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerFirst(ChannelHandler handler) {
        super.addHandlerFirst(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerFirst(String name, ChannelHandler handler) {
        super.addHandlerFirst(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandler(ChannelHandler handler) {
        super.addHandler(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations replaceHandler(String name, ChannelHandler handler) {
        super.replaceHandler(name, handler);
        return this;
    }

    @Override
    public HttpClientResponse removeHandler(String name) {
        super.removeHandler(name);
        return this;
    }

    @Override
    public HttpClientRequest addHeader(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public InetSocketAddress address() {
        return ((SocketChannel)this.channel()).remoteAddress();
    }

    @Override
    public HttpClientRequest chunkedTransfer(boolean chunked) {
        if (!this.hasSentHeaders() && HttpUtil.isTransferEncodingChunked(this.nettyRequest) != chunked) {
            this.requestHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked(this.nettyRequest, chunked);
        }
        return this;
    }

    @Override
    public HttpClientOperations context(Consumer<NettyContext> contextCallback) {
        contextCallback.accept(this.context());
        return this;
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return responseState.cookieHolder.getCachedCookies();
        }
        return null;
    }

    @Override
    public HttpClientRequest followRedirect() {
        this.redirectable = true;
        return this;
    }

    @Override
    public HttpClientRequest failOnClientError(boolean shouldFail) {
        this.clientError = shouldFail;
        return this;
    }

    @Override
    public HttpClientRequest failOnServerError(boolean shouldFail) {
        this.serverError = shouldFail;
        return this;
    }

    @Override
    protected void onInboundCancel() {
        if (this.isInboundDisposed()) {
            return;
        }
        this.channel().close();
    }

    @Override
    protected void onInboundClose() {
        if (this.isInboundCancelled() || this.isInboundDisposed()) {
            return;
        }
        if (this.responseState == null) {
            this.parentContext().fireContextError(new IOException("Connection closed prematurely"));
            return;
        }
        super.onInboundError(new IOException("Connection closed prematurely"));
    }

    @Override
    public HttpClientRequest header(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpClientRequest headers(HttpHeaders headers) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        String host = this.requestHeaders.get(HttpHeaderNames.HOST);
        this.requestHeaders.set(headers);
        this.requestHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)host);
        return this;
    }

    @Override
    public boolean isFollowRedirect() {
        return this.redirectable && this.redirectedFrom.length <= 50;
    }

    @Override
    public boolean isKeepAlive() {
        ResponseState rs = this.responseState;
        if (rs != null) {
            return HttpUtil.isKeepAlive(rs.response);
        }
        return HttpUtil.isKeepAlive(this.nettyRequest);
    }

    @Override
    public boolean isWebsocket() {
        return HttpClientOperations.get(this.channel()).getClass().equals(HttpClientWSOperations.class);
    }

    @Override
    public HttpClientRequest keepAlive(boolean keepAlive) {
        HttpUtil.setKeepAlive(this.nettyRequest, keepAlive);
        return this;
    }

    @Override
    public HttpMethod method() {
        return this.nettyRequest.method();
    }

    @Override
    public final HttpClientOperations onClose(Runnable onClose) {
        super.onClose(onClose);
        return this;
    }

    @Override
    public String[] redirectedFrom() {
        String[] redirectedFrom = this.redirectedFrom;
        String[] dest = new String[redirectedFrom.length];
        System.arraycopy(redirectedFrom, 0, dest, 0, redirectedFrom.length);
        return dest;
    }

    @Override
    public HttpHeaders requestHeaders() {
        return this.nettyRequest.headers();
    }

    @Override
    public HttpHeaders responseHeaders() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return responseState.headers;
        }
        return null;
    }

    @Override
    public Mono<Void> send() {
        if (this.markSentHeaderAndBody()) {
            HttpMessage request = this.newFullEmptyBodyMessage();
            return FutureMono.deferFuture(() -> this.channel().writeAndFlush(request));
        }
        return Mono.empty();
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> source) {
        if (this.method() == HttpMethod.GET || this.method() == HttpMethod.HEAD) {
            ByteBufAllocator alloc = this.channel().alloc();
            return this.then(Flux.from(source).doOnNext(ByteBuf::retain).collect(alloc::buffer, ByteBuf::writeBytes).flatMapMany(agg -> {
                if (!(this.hasSentHeaders() || HttpUtil.isTransferEncodingChunked(this.outboundHttpMessage()) || HttpUtil.isContentLengthSet(this.outboundHttpMessage()))) {
                    this.outboundHttpMessage().headers().setInt(HttpHeaderNames.CONTENT_LENGTH, agg.readableBytes());
                }
                return this.send(Mono.just(agg)).then();
            }));
        }
        return super.send(source);
    }

    @Override
    public Flux<Long> sendForm(Consumer<HttpClientRequest.Form> formCallback) {
        return new FluxSendForm(this, formCallback);
    }

    @Override
    public WebsocketOutbound sendWebsocket() {
        return this.sendWebsocket(null);
    }

    @Override
    public WebsocketOutbound sendWebsocket(String subprotocols) {
        final Mono<Void> m = this.withWebsocketSupport(this.websocketUri(), subprotocols, HttpClientOperations.noopHandler());
        return new WebsocketOutbound(){

            @Override
            public String selectedSubprotocol() {
                return null;
            }

            @Override
            public NettyContext context() {
                return HttpClientOperations.this;
            }

            @Override
            public Mono<Void> then() {
                return m;
            }
        };
    }

    @Override
    public Mono<Void> receiveWebsocket(String protocols, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        Objects.requireNonNull(websocketHandler, "websocketHandler");
        return this.withWebsocketSupport(this.websocketUri(), protocols, websocketHandler);
    }

    final URI websocketUri() {
        URI uri;
        try {
            String url = this.uri();
            if (url.startsWith("http") || url.startsWith("ws")) {
                uri = new URI(url);
            } else {
                String host = this.requestHeaders().get(HttpHeaderNames.HOST);
                uri = new URI((this.isSecure ? "wss" : "ws") + "://" + host + (url.startsWith("/") ? url : "/" + url));
            }
        }
        catch (URISyntaxException e) {
            throw Exceptions.bubble(e);
        }
        return uri;
    }

    @Override
    public WebsocketInbound receiveWebsocket() {
        return null;
    }

    @Override
    public HttpResponseStatus status() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return HttpResponseStatus.valueOf(responseState.response.status().code());
        }
        return null;
    }

    @Override
    public final String uri() {
        return this.nettyRequest.uri();
    }

    @Override
    public final HttpVersion version() {
        HttpVersion version = this.nettyRequest.protocolVersion();
        if (version.equals(HttpVersion.HTTP_1_0)) {
            return HttpVersion.HTTP_1_0;
        }
        if (version.equals(HttpVersion.HTTP_1_1)) {
            return HttpVersion.HTTP_1_1;
        }
        throw new IllegalStateException(version.protocolName() + " not supported");
    }

    @Override
    protected void onHandlerStart() {
        this.applyHandler();
    }

    @Override
    protected void onOutboundComplete() {
        if (this.isWebsocket() || this.isInboundCancelled()) {
            return;
        }
        if (this.markSentHeaderAndBody()) {
            if (log.isDebugEnabled()) {
                log.debug("No sendHeaders() called before complete, sending zero-length header");
            }
            this.channel().writeAndFlush(this.newFullEmptyBodyMessage());
        } else if (this.markSentBody()) {
            this.channel().writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
        }
        this.channel().read();
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (NettyContext.isPersistent(this.channel()) && this.responseState == null) {
            this.parentContext().fireContextError(err);
            this.onHandlerTerminate();
            return;
        }
        super.onOutboundError(err);
    }

    @Override
    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            if (response.decoderResult().isFailure()) {
                this.onInboundError(response.decoderResult().cause());
                return;
            }
            if (this.started) {
                if (log.isDebugEnabled()) {
                    log.debug("{} An HttpClientOperations cannot proceed more than one Response", this.channel(), response.headers().toString());
                }
                return;
            }
            this.started = true;
            this.setNettyResponse(response);
            if (!this.isKeepAlive()) {
                this.markPersistent(false);
            }
            if (this.isInboundCancelled()) {
                ReferenceCountUtil.release(msg);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("{} Received response (auto-read:{}) : {}", this.channel(), this.channel().config().isAutoRead(), this.responseHeaders().entries().toString());
            }
            if (this.checkResponseCode(response)) {
                this.prefetchMore(ctx);
                this.parentContext().fireContextActive(this);
            }
            if (msg instanceof FullHttpResponse) {
                super.onInboundNext(ctx, msg);
                this.onHandlerTerminate();
            }
            return;
        }
        if (msg instanceof LastHttpContent) {
            if (!this.started) {
                if (log.isDebugEnabled()) {
                    log.debug("{} HttpClientOperations received an incorrect end delimiter(previously used connection?)", this.channel());
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("{} Received last HTTP packet", this.channel());
            }
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                super.onInboundNext(ctx, msg);
            }
            this.channel().config().setAutoRead(true);
            this.onHandlerTerminate();
            return;
        }
        if (!this.started) {
            if (log.isDebugEnabled()) {
                if (msg instanceof ByteBufHolder) {
                    msg = ((ByteBufHolder)msg).content();
                }
                log.debug("{} HttpClientOperations received an incorrect chunk (previously used connection?)", this.channel(), msg);
            }
            return;
        }
        super.onInboundNext(ctx, msg);
        this.prefetchMore(ctx);
    }

    @Override
    protected HttpMessage outboundHttpMessage() {
        return this.nettyRequest;
    }

    final boolean checkResponseCode(HttpResponse response) {
        int code = response.status().code();
        if (code >= 500) {
            if (this.serverError) {
                if (log.isDebugEnabled()) {
                    log.debug("{} Received Server Error, stop reading: {}", this.channel(), response.toString());
                }
                HttpClientException ex = new HttpClientException(this.uri(), response);
                this.parentContext().fireContextError(ex);
                this.receive().subscribe();
                return false;
            }
            return true;
        }
        if (code >= 400) {
            if (this.clientError) {
                if (log.isDebugEnabled()) {
                    log.debug("{} Received Request Error, stop reading: {}", this.channel(), response.toString());
                }
                HttpClientException ex = new HttpClientException(this.uri(), response);
                this.parentContext().fireContextError(ex);
                this.receive().subscribe();
                return false;
            }
            return true;
        }
        if ((code == 301 || code == 302) && this.isFollowRedirect()) {
            if (log.isDebugEnabled()) {
                log.debug("{} Received Redirect location: {}", this.channel(), response.headers().entries().toString());
            }
            RedirectClientException ex = new RedirectClientException(this.uri(), response);
            this.parentContext().fireContextError(ex);
            this.receive().subscribe();
            return false;
        }
        return true;
    }

    @Override
    protected HttpMessage newFullEmptyBodyMessage() {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(this.version(), this.method(), this.uri());
        request.headers().set(this.requestHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING).setInt(HttpHeaderNames.CONTENT_LENGTH, 0));
        return request;
    }

    final HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    final void prefetchMore(ChannelHandlerContext ctx) {
        int inboundPrefetch = this.inboundPrefetch - 1;
        if (inboundPrefetch >= 0) {
            this.inboundPrefetch = inboundPrefetch;
            ctx.read();
        }
    }

    final void setNettyResponse(HttpResponse nettyResponse) {
        ResponseState state = this.responseState;
        if (state == null) {
            this.responseState = new ResponseState(nettyResponse, nettyResponse.headers());
        }
    }

    final Mono<Void> withWebsocketSupport(URI url, String protocols, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        if (this.markSentHeaders()) {
            this.addHandlerFirst("io.micrometer.shaded.reactor.left.httpAggregator", new HttpObjectAggregator(8192));
            HttpClientWSOperations ops = new HttpClientWSOperations(url, protocols, this);
            if (this.replace(ops)) {
                Mono<Void> handshake = FutureMono.from(ops.handshakerResult).then(Mono.defer(() -> Mono.from((Publisher)websocketHandler.apply(ops, ops))));
                if (websocketHandler != HttpClientOperations.noopHandler()) {
                    handshake = handshake.doAfterSuccessOrError(ops);
                }
                return handshake;
            }
        } else if (this.isWebsocket()) {
            HttpClientWSOperations ops = (HttpClientWSOperations)HttpClientOperations.get(this.channel());
            if (ops != null) {
                Mono<Void> handshake = FutureMono.from(ops.handshakerResult);
                if (websocketHandler != HttpClientOperations.noopHandler()) {
                    handshake = handshake.then(Mono.defer(() -> Mono.from((Publisher)websocketHandler.apply(ops, ops))).doAfterSuccessOrError(ops));
                }
                return handshake;
            }
        } else {
            log.error("Cannot enable websocket if headers have already been sent");
        }
        return Mono.error(new IllegalStateException("Failed to upgrade to websocket"));
    }

    static final class FluxSendForm
    extends Flux<Long> {
        static final HttpDataFactory DEFAULT_FACTORY = new DefaultHttpDataFactory(16384L);
        final HttpClientOperations parent;
        final Consumer<HttpClientRequest.Form> formCallback;

        FluxSendForm(HttpClientOperations parent, Consumer<HttpClientRequest.Form> formCallback) {
            this.parent = parent;
            this.formCallback = formCallback;
        }

        @Override
        public void subscribe(CoreSubscriber<? super Long> s) {
            if (this.parent.channel().eventLoop().inEventLoop()) {
                this._subscribe(s);
            } else {
                this.parent.channel().eventLoop().execute(() -> this._subscribe(s));
            }
        }

        void _subscribe(CoreSubscriber<? super Long> s) {
            if (!this.parent.markSentHeaders()) {
                Operators.error(s, new IllegalStateException("headers have already been sent"));
                return;
            }
            HttpDataFactory df = DEFAULT_FACTORY;
            try {
                HttpClientFormEncoder encoder = new HttpClientFormEncoder(df, this.parent.nettyRequest, false, HttpConstants.DEFAULT_CHARSET, HttpPostRequestEncoder.EncoderMode.RFC1738);
                this.formCallback.accept(encoder);
                encoder = encoder.applyChanges(this.parent.nettyRequest);
                df = encoder.newFactory;
                if (!encoder.isMultipart()) {
                    this.parent.chunkedTransfer(false);
                }
                this.parent.addHandlerFirst("io.micrometer.shaded.reactor.left.chunkedWriter", new ChunkedWriteHandler());
                boolean chunked = HttpUtil.isTransferEncodingChunked(this.parent.nettyRequest);
                HttpRequest r = encoder.finalizeRequest();
                if (!chunked) {
                    HttpUtil.setTransferEncodingChunked(r, false);
                    HttpUtil.setContentLength(r, encoder.length());
                }
                ChannelFuture f = this.parent.channel().writeAndFlush(r);
                Flux<? super Long> tail = encoder.progressFlux.onBackpressureLatest();
                if (encoder.cleanOnTerminate) {
                    tail = tail.doOnCancel(encoder).doAfterTerminate(encoder);
                }
                if (encoder.isChunked()) {
                    tail.subscribe(s);
                    this.parent.channel().writeAndFlush(encoder);
                } else {
                    FutureMono.from(f).cast(Long.class).switchIfEmpty(Mono.just(encoder.length())).flux().subscribe(s);
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                df.cleanRequestHttpData(this.parent.nettyRequest);
                Operators.error(s, Exceptions.unwrap(e));
            }
        }
    }

    static final class ResponseState {
        final HttpResponse response;
        final HttpHeaders headers;
        final Cookies cookieHolder;

        ResponseState(HttpResponse response, HttpHeaders headers) {
            this.response = response;
            this.headers = headers;
            this.cookieHolder = Cookies.newClientResponseHolder(headers);
        }
    }
}

