/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http.server;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.ipc.netty.http.server.HttpPredicate;
import io.micrometer.shaded.reactor.ipc.netty.http.server.HttpServerRequest;
import io.micrometer.shaded.reactor.ipc.netty.http.server.HttpServerResponse;
import io.micrometer.shaded.reactor.ipc.netty.http.server.HttpServerRoutes;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

final class DefaultHttpServerRoutes
implements HttpServerRoutes {
    private final CopyOnWriteArrayList<HttpRouteHandler> handlers = new CopyOnWriteArrayList();

    DefaultHttpServerRoutes() {
    }

    @Override
    public HttpServerRoutes directory(String uri, Path directory, Function<HttpServerResponse, HttpServerResponse> interceptor) {
        Objects.requireNonNull(directory, "directory");
        return this.route(HttpPredicate.prefix(uri), (req, resp) -> {
            Path p;
            String prefix = URI.create(req.uri()).getPath().replaceFirst(uri, "");
            if (prefix.charAt(0) == '/') {
                prefix = prefix.substring(1);
            }
            if (Files.isReadable(p = directory.resolve(prefix))) {
                if (interceptor != null) {
                    return ((HttpServerResponse)interceptor.apply((HttpServerResponse)resp)).sendFile(p);
                }
                return resp.sendFile(p);
            }
            return resp.sendNotFound();
        });
    }

    @Override
    public HttpServerRoutes route(Predicate<? super HttpServerRequest> condition, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(condition, "condition");
        Objects.requireNonNull(handler, "handler");
        if (condition instanceof HttpPredicate) {
            this.handlers.add(new HttpRouteHandler(condition, handler, (HttpPredicate)condition));
        } else {
            this.handlers.add(new HttpRouteHandler(condition, handler, null));
        }
        return this;
    }

    @Override
    public Publisher<Void> apply(HttpServerRequest request, HttpServerResponse response) {
        Iterator<HttpRouteHandler> iterator = this.handlers.iterator();
        try {
            while (iterator.hasNext()) {
                HttpRouteHandler cursor = iterator.next();
                if (!cursor.test(request)) continue;
                return cursor.apply(request, response);
            }
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            return Mono.error(t);
        }
        return response.sendNotFound();
    }

    static final class HttpRouteHandler
    implements BiFunction<HttpServerRequest, HttpServerResponse, Publisher<Void>>,
    Predicate<HttpServerRequest> {
        final Predicate<? super HttpServerRequest> condition;
        final BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler;
        final Function<? super String, Map<String, String>> resolver;

        HttpRouteHandler(Predicate<? super HttpServerRequest> condition, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler, Function<? super String, Map<String, String>> resolver) {
            this.condition = Objects.requireNonNull(condition, "condition");
            this.handler = Objects.requireNonNull(handler, "handler");
            this.resolver = resolver;
        }

        @Override
        public Publisher<Void> apply(HttpServerRequest request, HttpServerResponse response) {
            return this.handler.apply(request.paramsResolver(this.resolver), response);
        }

        @Override
        public boolean test(HttpServerRequest o) {
            return this.condition.test(o);
        }
    }
}

