/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.lang.Nullable;
import io.micrometer.statsd.StatsdFlavor;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.internal.MemoizingFunction;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FlavorStatsdLineBuilder
implements StatsdLineBuilder {
    private final Meter.Id id;
    private final StatsdFlavor flavor;
    private final HierarchicalNameMapper nameMapper;
    private final MeterRegistry.Config config;
    private final Function<NamingConvention, String> datadogTagString;
    private final Function<NamingConvention, String> telegrafTagString;

    public FlavorStatsdLineBuilder(Meter.Id id, StatsdFlavor flavor, HierarchicalNameMapper nameMapper, MeterRegistry.Config config) {
        this.id = id;
        this.flavor = flavor;
        this.nameMapper = nameMapper;
        this.config = config;
        this.datadogTagString = MemoizingFunction.memoize(convention -> id.getTags().iterator().hasNext() ? id.getConventionTags(convention).stream().map(t -> t.getKey() + ":" + t.getValue()).collect(Collectors.joining(",")) : null);
        this.telegrafTagString = MemoizingFunction.memoize(convention -> id.getTags().iterator().hasNext() ? id.getConventionTags(convention).stream().map(t -> t.getKey() + "=" + t.getValue()).collect(Collectors.joining(",")) : null);
    }

    @Override
    public String count(long amount, Statistic stat) {
        return this.line(Long.toString(amount), stat, "c");
    }

    @Override
    public String gauge(double amount, Statistic stat) {
        return this.line(DoubleFormat.decimalOrNan((double)amount), stat, "g");
    }

    @Override
    public String histogram(double amount) {
        return this.line(DoubleFormat.decimalOrNan((double)amount), null, "h");
    }

    @Override
    public String timing(double timeMs) {
        return this.line(DoubleFormat.decimalOrNan((double)timeMs), null, "ms");
    }

    private String line(String amount, @Nullable Statistic stat, String type) {
        switch (this.flavor) {
            case ETSY: {
                return this.metricName(stat) + ":" + amount + "|" + type;
            }
            case DATADOG: {
                return this.metricName(stat) + ":" + amount + "|" + type + this.tags(stat, this.datadogTagString.apply(this.config.namingConvention()), ":", "|#");
            }
        }
        return this.metricName(stat) + this.tags(stat, this.telegrafTagString.apply(this.config.namingConvention()), "=", ",") + ":" + amount + "|" + type;
    }

    private String tags(@Nullable Statistic stat, String otherTags, String keyValueSeparator, String preamble) {
        String tags = Stream.of(stat == null ? null : "statistic" + keyValueSeparator + stat.getTagValueRepresentation(), otherTags).filter(Objects::nonNull).collect(Collectors.joining(","));
        if (!tags.isEmpty()) {
            tags = preamble + tags;
        }
        return tags;
    }

    private String metricName(@Nullable Statistic stat) {
        switch (this.flavor) {
            case ETSY: {
                return this.nameMapper.toHierarchicalName(stat != null ? this.id.withTag(stat) : this.id, this.config.namingConvention());
            }
        }
        return this.config.namingConvention().name(this.id.getName(), this.id.getType(), this.id.getBaseUnit());
    }
}

