/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioFile;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.channel.data.AbstractFileChunkedStrategy;
import reactor.ipc.netty.channel.data.FileChunkedStrategy;
import reactor.ipc.netty.http.HttpInfos;

public abstract class HttpOperations<INBOUND extends NettyInbound, OUTBOUND extends NettyOutbound>
extends ChannelOperations<INBOUND, OUTBOUND>
implements HttpInfos {
    volatile int statusAndHeadersSent = 0;
    static final int READY = 0;
    static final int HEADERS_SENT = 1;
    static final int BODY_SENT = 2;
    static final AtomicIntegerFieldUpdater<HttpOperations> HTTP_STATE = AtomicIntegerFieldUpdater.newUpdater(HttpOperations.class, "statusAndHeadersSent");
    static final ChannelInboundHandler HTTP_EXTRACTOR = NettyPipeline.inboundHandler((ctx, msg) -> {
        if (msg instanceof ByteBufHolder) {
            if (msg instanceof FullHttpMessage) {
                ctx.fireChannelRead(msg);
            } else {
                ByteBuf bb = ((ByteBufHolder)msg).content();
                ctx.fireChannelRead((Object)bb);
                if (msg instanceof LastHttpContent) {
                    ctx.fireChannelRead((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                }
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    });

    protected HttpOperations(Channel ioChannel, HttpOperations<INBOUND, OUTBOUND> replaced) {
        super(ioChannel, replaced);
        this.statusAndHeadersSent = replaced.statusAndHeadersSent;
    }

    protected HttpOperations(Channel ioChannel, BiFunction<? super INBOUND, ? super OUTBOUND, ? extends Publisher<Void>> handler, ContextHandler<?> context) {
        super(ioChannel, handler, context);
        ioChannel.config().setAutoRead(false);
    }

    public final boolean hasSentHeaders() {
        return this.statusAndHeadersSent != 0;
    }

    @Override
    public boolean isWebsocket() {
        return false;
    }

    public NettyOutbound sendHeaders() {
        if (this.hasSentHeaders()) {
            return this;
        }
        return this.then((Publisher<Void>)Mono.empty());
    }

    @Override
    public Mono<Void> then() {
        if (this.hasSentHeaders()) {
            return Mono.empty();
        }
        return FutureMono.deferFuture(() -> {
            if (this.markSentHeaders()) {
                HttpMessage msg;
                if (HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
                    this.outboundHttpMessage().headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                    msg = HttpUtil.getContentLength((HttpMessage)this.outboundHttpMessage(), (int)0) == 0 ? this.newFullEmptyBodyMessage() : this.outboundHttpMessage();
                } else {
                    msg = this.outboundHttpMessage();
                }
                this.preSendHeadersAndStatus();
                return this.channel().writeAndFlush((Object)msg);
            }
            return this.channel().newSucceededFuture();
        });
    }

    protected abstract void preSendHeadersAndStatus();

    protected abstract HttpMessage newFullEmptyBodyMessage();

    @Override
    public final NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file);
        if (this.hasSentHeaders()) {
            return super.sendFile(file, position, count);
        }
        if (!HttpUtil.isTransferEncodingChunked((HttpMessage)this.outboundHttpMessage()) && !HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage()) && count < Integer.MAX_VALUE) {
            this.outboundHttpMessage().headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (int)count);
        } else if (!HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
            this.outboundHttpMessage().headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH).remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.outboundHttpMessage(), (boolean)true);
        }
        return super.sendFile(file, position, count);
    }

    @Override
    public FileChunkedStrategy<?> getFileChunkedStrategy() {
        return new AbstractFileChunkedStrategy<HttpContent>(){

            @Override
            public ChunkedInput<HttpContent> chunkFile(FileChannel fileChannel, long offset, long length, int chunkSize) {
                try {
                    return new HttpChunkedInput((ChunkedInput)new ChunkedNioFile(fileChannel, offset, length, chunkSize));
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }

            @Override
            public void afterWrite(NettyContext context) {
                HttpOperations.this.markSentBody();
            }
        };
    }

    @Override
    public String toString() {
        if (this.isWebsocket()) {
            return "ws:" + this.uri();
        }
        return this.method().name() + ":" + this.uri();
    }

    @Override
    public HttpOperations<INBOUND, OUTBOUND> addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        if (this.channel().pipeline().context(handler) == null) {
            return this;
        }
        HttpOperations.autoAddHttpExtractor(this, name, handler);
        return this;
    }

    static void autoAddHttpExtractor(NettyContext c, String name, ChannelHandler handler) {
        if (handler instanceof ByteToMessageDecoder || handler instanceof ByteToMessageCodec || handler instanceof CombinedChannelDuplexHandler) {
            String extractorName = name + "$extractor";
            if (c.channel().pipeline().context(extractorName) != null) {
                return;
            }
            c.channel().pipeline().addBefore(name, extractorName, (ChannelHandler)HTTP_EXTRACTOR);
            if (NettyContext.isPersistent(c.channel())) {
                c.onClose(() -> c.removeHandler(extractorName));
            }
        }
    }

    protected final boolean markSentHeaders() {
        return HTTP_STATE.compareAndSet(this, 0, 1);
    }

    protected final boolean markSentBody() {
        return HTTP_STATE.compareAndSet(this, 1, 2);
    }

    protected final boolean markSentHeaderAndBody() {
        return HTTP_STATE.compareAndSet(this, 0, 2);
    }

    protected abstract HttpMessage outboundHttpMessage();
}

