/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.processor.BeanArchives;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.runtime.LifecycleEventRunner;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class BeanArchiveProcessor {
    @Inject
    ApplicationArchivesBuildItem applicationArchivesBuildItem;
    @Inject
    List<BeanDefiningAnnotationBuildItem> additionalBeanDefiningAnnotations;
    @Inject
    List<AdditionalBeanBuildItem> additionalBeans;
    @Inject
    List<GeneratedBeanBuildItem> generatedBeans;
    @Inject
    BuildProducer<GeneratedClassBuildItem> generatedClass;

    @BuildStep
    public BeanArchiveIndexBuildItem build() throws Exception {
        IndexView applicationIndex = this.buildApplicationIndex();
        Indexer additionalBeanIndexer = new Indexer();
        ArrayList<String> additionalBeans = new ArrayList<String>();
        for (AdditionalBeanBuildItem additionalBeanBuildItem : this.additionalBeans) {
            additionalBeans.addAll(additionalBeanBuildItem.getBeanClasses());
        }
        additionalBeans.add(LifecycleEventRunner.class.getName());
        HashSet additionalIndex = new HashSet();
        for (String beanClass : additionalBeans) {
            IndexingUtil.indexClass((String)beanClass, (Indexer)additionalBeanIndexer, (IndexView)applicationIndex, additionalIndex, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        HashSet<DotName> hashSet = new HashSet<DotName>();
        for (GeneratedBeanBuildItem generatedBeanClass : this.generatedBeans) {
            IndexingUtil.indexClass((String)generatedBeanClass.getName(), (Indexer)additionalBeanIndexer, (IndexView)applicationIndex, additionalIndex, (ClassLoader)Thread.currentThread().getContextClassLoader(), (byte[])generatedBeanClass.getData());
            hashSet.add(DotName.createSimple((String)generatedBeanClass.getName().replace('/', '.')));
            this.generatedClass.produce((BuildItem)new GeneratedClassBuildItem(true, generatedBeanClass.getName(), generatedBeanClass.getData(), generatedBeanClass.getSource()));
        }
        return new BeanArchiveIndexBuildItem(BeanArchives.buildBeanArchiveIndex((ClassLoader)Thread.currentThread().getContextClassLoader(), (IndexView[])new IndexView[]{applicationIndex, additionalBeanIndexer.complete()}), hashSet, additionalBeans);
    }

    private IndexView buildApplicationIndex() {
        Set archives = this.applicationArchivesBuildItem.getAllApplicationArchives();
        HashSet<DotName> stereotypes = new HashSet<DotName>();
        for (ApplicationArchive archive : archives) {
            Collection annotations = archive.getIndex().getAnnotations(DotNames.STEREOTYPE);
            if (annotations.isEmpty()) continue;
            for (AnnotationInstance annotationInstance : annotations) {
                if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                stereotypes.add(annotationInstance.target().asClass().name());
            }
        }
        Set beanDefiningAnnotations = BeanDeployment.initBeanDefiningAnnotations((Collection)this.additionalBeanDefiningAnnotations.stream().map(bda -> new BeanDefiningAnnotation(bda.getName(), bda.getDefaultScope())).collect(Collectors.toList()), stereotypes);
        beanDefiningAnnotations.add(DotNames.QUALIFIER);
        beanDefiningAnnotations.add(DotNames.INTERCEPTOR_BINDING);
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        for (ApplicationArchive archive : this.applicationArchivesBuildItem.getApplicationArchives()) {
            IndexView index = archive.getIndex();
            if (archive.getChildPath("META-INF/beans.xml") == null && archive.getChildPath("WEB-INF/beans.xml") == null && (!index.getAllKnownImplementors(DotNames.EXTENSION).isEmpty() || !this.containsBeanDefiningAnnotation(index, beanDefiningAnnotations))) continue;
            indexes.add(index);
        }
        indexes.add(this.applicationArchivesBuildItem.getRootArchive().getIndex());
        return CompositeIndex.create(indexes);
    }

    boolean containsBeanDefiningAnnotation(IndexView index, Collection<DotName> beanDefiningAnnotations) {
        for (DotName beanDefiningAnnotation : beanDefiningAnnotations) {
            if (index.getAnnotations(beanDefiningAnnotation).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

