/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor;

import io.quarkus.dependencies.Category;
import io.quarkus.dependencies.Extension;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.ResourceInputStreamConsumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Dependency;

public class CombinedQuarkusPlatformDescriptor
implements QuarkusPlatformDescriptor {
    private final QuarkusPlatformDescriptor master;
    private final List<QuarkusPlatformDescriptor> platforms;
    private List<Dependency> managedDeps;
    private List<Extension> extensions;
    private List<Category> categories;

    public static Builder builder() {
        return new Builder();
    }

    private CombinedQuarkusPlatformDescriptor(Builder builder) {
        if (builder.platforms.isEmpty()) {
            throw new IllegalArgumentException("No platforms to combine");
        }
        this.master = (QuarkusPlatformDescriptor)builder.platforms.get(0);
        this.platforms = new ArrayList<QuarkusPlatformDescriptor>(builder.platforms);
    }

    @Override
    public String getBomGroupId() {
        return this.master.getBomGroupId();
    }

    @Override
    public String getBomArtifactId() {
        return this.master.getBomArtifactId();
    }

    @Override
    public String getBomVersion() {
        return this.master.getBomVersion();
    }

    @Override
    public String getQuarkusVersion() {
        return this.master.getQuarkusVersion();
    }

    @Override
    public List<Dependency> getManagedDependencies() {
        if (this.managedDeps != null) {
            return this.managedDeps;
        }
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        HashSet<DepKey> depKeys = new HashSet<DepKey>();
        for (QuarkusPlatformDescriptor platform : this.platforms) {
            for (Dependency dep : platform.getManagedDependencies()) {
                if (!depKeys.add(new DepKey(dep))) continue;
                deps.add(dep);
            }
        }
        this.managedDeps = deps;
        return this.managedDeps;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions != null) {
            return this.extensions;
        }
        ArrayList<Extension> list = new ArrayList<Extension>();
        HashSet<DepKey> depKeys = new HashSet<DepKey>();
        for (QuarkusPlatformDescriptor platform : this.platforms) {
            for (Extension ext : platform.getExtensions()) {
                if (!depKeys.add(new DepKey(ext.getGroupId(), ext.getArtifactId()))) continue;
                list.add(ext);
            }
        }
        this.extensions = list;
        return this.extensions;
    }

    @Override
    public List<Category> getCategories() {
        if (this.categories != null) {
            return this.categories;
        }
        ArrayList<Category> list = new ArrayList<Category>();
        HashSet<String> ids = new HashSet<String>();
        for (QuarkusPlatformDescriptor platform : this.platforms) {
            for (Category cat : platform.getCategories()) {
                if (!ids.add(cat.getId())) continue;
                list.add(cat);
            }
        }
        this.categories = list;
        return this.categories;
    }

    @Override
    public String getTemplate(String name) {
        for (QuarkusPlatformDescriptor platform : this.platforms) {
            String template = platform.getTemplate(name);
            if (template == null) continue;
            return template;
        }
        return null;
    }

    @Override
    public <T> T loadResource(String name, ResourceInputStreamConsumer<T> consumer) throws IOException {
        for (QuarkusPlatformDescriptor platform : this.platforms) {
            try {
                return platform.loadResource(name, consumer);
            }
            catch (IOException iOException) {
            }
        }
        throw new IOException("Failed to locate resource " + name);
    }

    private static class DepKey {
        final String groupId;
        final String artifactId;
        final String classifier;
        final String type;

        DepKey(Dependency dep) {
            this(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getType());
        }

        DepKey(String groupId, String artifactId) {
            this(groupId, artifactId, null, null);
        }

        DepKey(String groupId, String artifactId, String classifier, String type) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = classifier;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DepKey other = (DepKey)obj;
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    public static class Builder {
        private List<QuarkusPlatformDescriptor> platforms = new ArrayList<QuarkusPlatformDescriptor>();

        private Builder() {
        }

        public Builder addPlatform(QuarkusPlatformDescriptor platform) {
            this.platforms.add(platform);
            return this;
        }

        public QuarkusPlatformDescriptor build() {
            return new CombinedQuarkusPlatformDescriptor(this);
        }
    }
}

