/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.netty.channel.Channel;
import io.seata.common.util.NetUtil;
import io.seata.core.protocol.IncompatibleVersionException;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public class Version {
    private static final String CURRENT = "1.4.1";
    private static final String VERSION_0_7_1 = "0.7.1";
    private static final int MAX_VERSION_DOT = 3;
    public static final Map<String, String> VERSION_MAP = new ConcurrentHashMap<String, String>();

    private Version() {
    }

    public static String getCurrent() {
        return CURRENT;
    }

    public static void putChannelVersion(Channel c, String v) {
        VERSION_MAP.put(NetUtil.toStringAddress((SocketAddress)c.remoteAddress()), v);
    }

    public static String getChannelVersion(Channel c) {
        return VERSION_MAP.get(NetUtil.toStringAddress((SocketAddress)c.remoteAddress()));
    }

    public static void checkVersion(String version) throws IncompatibleVersionException {
        long current = Version.convertVersion(CURRENT);
        long clientVersion = Version.convertVersion(version);
        long divideVersion = Version.convertVersion(VERSION_0_7_1);
        if (current > divideVersion && clientVersion < divideVersion || current < divideVersion && clientVersion > divideVersion) {
            throw new IncompatibleVersionException("incompatible client version:" + version);
        }
    }

    private static long convertVersion(String version) throws IncompatibleVersionException {
        String[] parts = StringUtils.split((String)version, (char)'.');
        long result = 0L;
        int i = 1;
        int size = parts.length;
        if (size > 4) {
            throw new IncompatibleVersionException("incompatible version format:" + version);
        }
        size = 4;
        for (String part : parts) {
            if (StringUtils.isNumeric((String)part)) {
                result += Version.calculatePartValue(part, size, i);
            } else {
                String[] subParts = StringUtils.split((String)part, (char)'-');
                if (StringUtils.isNumeric((String)subParts[0])) {
                    result += Version.calculatePartValue(subParts[0], size, i);
                }
            }
            ++i;
        }
        return result;
    }

    private static long calculatePartValue(String partNumeric, int size, int index) {
        return Long.parseLong(partNumeric) * Double.valueOf(Math.pow(100.0, size - index)).longValue();
    }
}

