/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.api;

import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.yaml.masterslave.YamlMasterSlaveDataSource;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;

public final class MasterSlaveDataSourceFactory {
    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig) throws SQLException {
        return new MasterSlaveDataSource(masterSlaveRuleConfig.build(dataSourceMap));
    }

    public static DataSource createDataSource(File yamlFile) throws SQLException, IOException {
        return new YamlMasterSlaveDataSource(yamlFile);
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, File yamlFile) throws SQLException, IOException {
        return new YamlMasterSlaveDataSource(dataSourceMap, yamlFile);
    }

    public static DataSource createDataSource(byte[] yamlByteArray) throws SQLException, IOException {
        return new YamlMasterSlaveDataSource(yamlByteArray);
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, byte[] yamlByteArray) throws SQLException, IOException {
        return new YamlMasterSlaveDataSource(dataSourceMap, yamlByteArray);
    }

    private MasterSlaveDataSourceFactory() {
    }
}

