/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.executor.type.batch;

import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.constant.SQLType;
import io.shardingjdbc.core.executor.BaseStatementUnit;
import io.shardingjdbc.core.executor.ExecuteCallback;
import io.shardingjdbc.core.executor.ExecutorEngine;
import io.shardingjdbc.core.executor.type.batch.BatchPreparedStatementUnit;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class BatchPreparedStatementExecutor {
    private final ExecutorEngine executorEngine;
    private final DatabaseType dbType;
    private final SQLType sqlType;
    private final Collection<BatchPreparedStatementUnit> batchPreparedStatementUnits;
    private final List<List<Object>> parameterSets;

    public int[] executeBatch() {
        return this.accumulate(this.executorEngine.executeBatch(this.sqlType, this.batchPreparedStatementUnits, this.parameterSets, new ExecuteCallback<int[]>(){

            @Override
            public int[] execute(BaseStatementUnit baseStatementUnit) throws Exception {
                return baseStatementUnit.getStatement().executeBatch();
            }
        }));
    }

    private int[] accumulate(List<int[]> results) {
        int[] result = new int[this.parameterSets.size()];
        int count = 0;
        for (BatchPreparedStatementUnit each : this.batchPreparedStatementUnits) {
            for (Map.Entry<Integer, Integer> entry : each.getJdbcAndActualAddBatchCallTimesMap().entrySet()) {
                int value;
                int n = value = null == results.get(count) ? 0 : results.get(count)[entry.getValue()];
                if (DatabaseType.Oracle == this.dbType) {
                    result[entry.getKey().intValue()] = value;
                    continue;
                }
                int n2 = entry.getKey();
                result[n2] = result[n2] + value;
            }
            ++count;
        }
        return result;
    }

    @ConstructorProperties(value={"executorEngine", "dbType", "sqlType", "batchPreparedStatementUnits", "parameterSets"})
    public BatchPreparedStatementExecutor(ExecutorEngine executorEngine, DatabaseType dbType, SQLType sqlType, Collection<BatchPreparedStatementUnit> batchPreparedStatementUnits, List<List<Object>> parameterSets) {
        this.executorEngine = executorEngine;
        this.dbType = dbType;
        this.sqlType = sqlType;
        this.batchPreparedStatementUnits = batchPreparedStatementUnits;
        this.parameterSets = parameterSets;
    }
}

