/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.jdbc.core.datasource;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.constant.SQLType;
import io.shardingjdbc.core.hint.HintManagerHolder;
import io.shardingjdbc.core.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingjdbc.core.jdbc.core.connection.MasterSlaveConnection;
import io.shardingjdbc.core.jdbc.core.datasource.NamedDataSource;
import io.shardingjdbc.core.rule.MasterSlaveRule;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;

public class MasterSlaveDataSource
extends AbstractDataSourceAdapter {
    private static final ThreadLocal<Boolean> DML_FLAG = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private MasterSlaveRule masterSlaveRule;

    public MasterSlaveDataSource(MasterSlaveRule masterSlaveRule) throws SQLException {
        super(MasterSlaveDataSource.getAllDataSources(masterSlaveRule.getMasterDataSource(), masterSlaveRule.getSlaveDataSourceMap().values()));
        this.masterSlaveRule = masterSlaveRule;
    }

    private static Collection<DataSource> getAllDataSources(DataSource masterDataSource, Collection<DataSource> slaveDataSources) {
        LinkedList<DataSource> result = new LinkedList<DataSource>(slaveDataSources);
        result.add(masterDataSource);
        return result;
    }

    public Map<String, DataSource> getAllDataSources() {
        HashMap<String, DataSource> result = new HashMap<String, DataSource>(this.masterSlaveRule.getSlaveDataSourceMap().size() + 1, 1.0f);
        result.put(this.masterSlaveRule.getMasterDataSourceName(), this.masterSlaveRule.getMasterDataSource());
        result.putAll(this.masterSlaveRule.getSlaveDataSourceMap());
        return result;
    }

    public static void resetDMLFlag() {
        DML_FLAG.remove();
    }

    public NamedDataSource getDataSource(SQLType sqlType) {
        if (this.isMasterRoute(sqlType)) {
            DML_FLAG.set(true);
            return new NamedDataSource(this.masterSlaveRule.getMasterDataSourceName(), this.masterSlaveRule.getMasterDataSource());
        }
        String selectedSourceName = this.masterSlaveRule.getStrategy().getDataSource(this.masterSlaveRule.getName(), this.masterSlaveRule.getMasterDataSourceName(), new ArrayList<String>(this.masterSlaveRule.getSlaveDataSourceMap().keySet()));
        DataSource selectedSource = selectedSourceName.equals(this.masterSlaveRule.getMasterDataSourceName()) ? this.masterSlaveRule.getMasterDataSource() : this.masterSlaveRule.getSlaveDataSourceMap().get(selectedSourceName);
        Preconditions.checkNotNull((Object)selectedSource, (Object)"");
        return new NamedDataSource(selectedSourceName, selectedSource);
    }

    private boolean isMasterRoute(SQLType sqlType) {
        return SQLType.DQL != sqlType || DML_FLAG.get() != false || HintManagerHolder.isMasterRouteOnly();
    }

    public void renew(MasterSlaveRule masterSlaveRule) throws SQLException {
        Preconditions.checkState((this.getDatabaseType() == this.getDatabaseType(Collections.singletonList(masterSlaveRule.getMasterDataSource())) ? 1 : 0) != 0, (Object)"Cannot change database type dynamically.");
        Preconditions.checkState((this.getDatabaseType() == this.getDatabaseType(masterSlaveRule.getSlaveDataSourceMap().values()) ? 1 : 0) != 0, (Object)"Cannot change database type dynamically.");
        this.masterSlaveRule = masterSlaveRule;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new MasterSlaveConnection(this);
    }

    public MasterSlaveRule getMasterSlaveRule() {
        return this.masterSlaveRule;
    }
}

