/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.jdbc.core.datasource;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.constant.ShardingProperties;
import io.shardingjdbc.core.constant.ShardingPropertiesConstant;
import io.shardingjdbc.core.executor.ExecutorEngine;
import io.shardingjdbc.core.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingjdbc.core.jdbc.core.ShardingContext;
import io.shardingjdbc.core.jdbc.core.connection.ShardingConnection;
import io.shardingjdbc.core.rule.ShardingRule;
import java.sql.SQLException;
import java.util.Properties;

public class ShardingDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private ShardingProperties shardingProperties;
    private ExecutorEngine executorEngine;
    private ShardingContext shardingContext;

    public ShardingDataSource(ShardingRule shardingRule) throws SQLException {
        this(shardingRule, new Properties());
    }

    public ShardingDataSource(ShardingRule shardingRule, Properties props) throws SQLException {
        super(shardingRule.getDataSourceMap().values());
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
        int executorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        this.executorEngine = new ExecutorEngine(executorSize);
        boolean showSQL = (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        this.shardingContext = new ShardingContext(shardingRule, this.getDatabaseType(), this.executorEngine, showSQL);
    }

    public void renew(ShardingRule newShardingRule, Properties newProps) throws SQLException {
        Preconditions.checkState((this.getDatabaseType() == this.getDatabaseType(newShardingRule.getDataSourceMap().values()) ? 1 : 0) != 0, (Object)"Cannot change database type dynamically.");
        ShardingProperties newShardingProperties = new ShardingProperties(null == newProps ? new Properties() : newProps);
        int originalExecutorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        int newExecutorSize = (Integer)newShardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        if (originalExecutorSize != newExecutorSize) {
            this.executorEngine.close();
            this.executorEngine = new ExecutorEngine(newExecutorSize);
        }
        boolean newShowSQL = (Boolean)newShardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        this.shardingProperties = newShardingProperties;
        this.shardingContext = new ShardingContext(newShardingRule, this.getDatabaseType(), this.executorEngine, newShowSQL);
    }

    @Override
    public ShardingConnection getConnection() throws SQLException {
        return new ShardingConnection(this.shardingContext);
    }

    @Override
    public void close() {
        this.executorEngine.close();
    }
}

