/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.clause;

import com.google.common.base.Optional;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Keyword;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.clause.AliasClauseParser;
import io.shardingjdbc.core.parsing.parser.clause.ExpressionClauseParser;
import io.shardingjdbc.core.parsing.parser.clause.SQLClauseParser;
import io.shardingjdbc.core.parsing.parser.context.condition.Column;
import io.shardingjdbc.core.parsing.parser.context.condition.Condition;
import io.shardingjdbc.core.parsing.parser.context.limit.Limit;
import io.shardingjdbc.core.parsing.parser.context.limit.LimitValue;
import io.shardingjdbc.core.parsing.parser.context.selectitem.SelectItem;
import io.shardingjdbc.core.parsing.parser.context.table.Table;
import io.shardingjdbc.core.parsing.parser.context.table.Tables;
import io.shardingjdbc.core.parsing.parser.expression.SQLExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLIdentifierExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLNumberExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLPlaceholderExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLPropertyExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLTextExpression;
import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingjdbc.core.parsing.parser.token.OffsetToken;
import io.shardingjdbc.core.parsing.parser.token.RowCountToken;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.util.SQLUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class WhereClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final AliasClauseParser aliasClauseParser;
    private final ExpressionClauseParser expressionClauseParser;

    public WhereClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.aliasClauseParser = new AliasClauseParser(lexerEngine);
        this.expressionClauseParser = new ExpressionClauseParser(lexerEngine);
    }

    public void parse(ShardingRule shardingRule, SQLStatement sqlStatement, List<SelectItem> items) {
        this.aliasClauseParser.parse();
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.WHERE)) {
            this.parseConditions(shardingRule, sqlStatement, items);
        }
    }

    private void parseConditions(ShardingRule shardingRule, SQLStatement sqlStatement, List<SelectItem> items) {
        do {
            this.parseComparisonCondition(shardingRule, sqlStatement, items);
        } while (this.lexerEngine.skipIfEqual(DefaultKeyword.AND));
        this.lexerEngine.unsupportedIfEqual(DefaultKeyword.OR);
    }

    private void parseComparisonCondition(ShardingRule shardingRule, SQLStatement sqlStatement, List<SelectItem> items) {
        this.lexerEngine.skipIfEqual(Symbol.LEFT_PAREN);
        SQLExpression left = this.expressionClauseParser.parse(sqlStatement);
        if (this.lexerEngine.skipIfEqual(Symbol.EQ)) {
            this.parseEqualCondition(shardingRule, sqlStatement, left);
            this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
            return;
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.IN)) {
            this.parseInCondition(shardingRule, sqlStatement, left);
            this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
            return;
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.BETWEEN)) {
            this.parseBetweenCondition(shardingRule, sqlStatement, left);
            this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
            return;
        }
        if (sqlStatement instanceof SelectStatement && this.isRowNumberCondition(items, left)) {
            if (this.lexerEngine.skipIfEqual(Symbol.LT, Symbol.LT_EQ)) {
                this.parseRowCountCondition((SelectStatement)sqlStatement);
                return;
            }
            if (this.lexerEngine.skipIfEqual(Symbol.GT, Symbol.GT_EQ)) {
                this.parseOffsetCondition((SelectStatement)sqlStatement);
                return;
            }
        }
        LinkedList<Keyword> otherConditionOperators = new LinkedList<Keyword>(Arrays.asList(this.getCustomizedOtherConditionOperators()));
        otherConditionOperators.addAll(Arrays.asList(Symbol.LT, Symbol.LT_EQ, Symbol.GT, Symbol.GT_EQ, Symbol.LT_GT, Symbol.BANG_EQ, Symbol.BANG_GT, Symbol.BANG_LT, DefaultKeyword.LIKE, DefaultKeyword.IS));
        if (this.lexerEngine.skipIfEqual(otherConditionOperators.toArray(new Keyword[otherConditionOperators.size()]))) {
            this.parseOtherCondition(sqlStatement);
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.NOT)) {
            this.lexerEngine.nextToken();
            this.lexerEngine.skipIfEqual(Symbol.LEFT_PAREN);
            this.parseOtherCondition(sqlStatement);
            this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
        }
        this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
    }

    private void parseEqualCondition(ShardingRule shardingRule, SQLStatement sqlStatement, SQLExpression left) {
        Optional<Column> column;
        SQLExpression right = this.expressionClauseParser.parse(sqlStatement);
        if ((sqlStatement.getTables().isSingleTable() || left instanceof SQLPropertyExpression) && (right instanceof SQLNumberExpression || right instanceof SQLTextExpression || right instanceof SQLPlaceholderExpression) && (column = this.find(sqlStatement.getTables(), left)).isPresent()) {
            sqlStatement.getConditions().add(new Condition((Column)column.get(), right), shardingRule);
        }
    }

    private void parseInCondition(ShardingRule shardingRule, SQLStatement sqlStatement, SQLExpression left) {
        this.lexerEngine.accept(Symbol.LEFT_PAREN);
        LinkedList<SQLExpression> rights = new LinkedList<SQLExpression>();
        do {
            this.lexerEngine.skipIfEqual(Symbol.COMMA);
            rights.add(this.expressionClauseParser.parse(sqlStatement));
        } while (!this.lexerEngine.equalAny(Symbol.RIGHT_PAREN));
        Optional<Column> column = this.find(sqlStatement.getTables(), left);
        if (column.isPresent()) {
            sqlStatement.getConditions().add(new Condition((Column)column.get(), rights), shardingRule);
        }
        this.lexerEngine.nextToken();
    }

    private void parseBetweenCondition(ShardingRule shardingRule, SQLStatement sqlStatement, SQLExpression left) {
        LinkedList<SQLExpression> rights = new LinkedList<SQLExpression>();
        rights.add(this.expressionClauseParser.parse(sqlStatement));
        this.lexerEngine.accept(DefaultKeyword.AND);
        rights.add(this.expressionClauseParser.parse(sqlStatement));
        Optional<Column> column = this.find(sqlStatement.getTables(), left);
        if (column.isPresent()) {
            sqlStatement.getConditions().add(new Condition((Column)column.get(), (SQLExpression)rights.get(0), (SQLExpression)rights.get(1)), shardingRule);
        }
    }

    private boolean isRowNumberCondition(List<SelectItem> items, SQLExpression sqlExpression) {
        String columnLabel = null;
        if (sqlExpression instanceof SQLIdentifierExpression) {
            columnLabel = ((SQLIdentifierExpression)sqlExpression).getName();
        } else if (sqlExpression instanceof SQLPropertyExpression) {
            columnLabel = ((SQLPropertyExpression)sqlExpression).getName();
        }
        return null != columnLabel && this.isRowNumberCondition(items, columnLabel);
    }

    protected boolean isRowNumberCondition(List<SelectItem> items, String columnLabel) {
        return false;
    }

    private void parseRowCountCondition(SelectStatement selectStatement) {
        SQLExpression sqlExpression = this.expressionClauseParser.parse(selectStatement);
        if (null == selectStatement.getLimit()) {
            selectStatement.setLimit(new Limit(false));
        }
        if (sqlExpression instanceof SQLNumberExpression) {
            int rowCount = ((SQLNumberExpression)sqlExpression).getNumber().intValue();
            selectStatement.getLimit().setRowCount(new LimitValue(rowCount, -1));
            selectStatement.getSqlTokens().add(new RowCountToken(this.lexerEngine.getCurrentToken().getEndPosition() - String.valueOf(rowCount).length() - this.lexerEngine.getCurrentToken().getLiterals().length(), rowCount));
        } else if (sqlExpression instanceof SQLPlaceholderExpression) {
            selectStatement.getLimit().setRowCount(new LimitValue(-1, ((SQLPlaceholderExpression)sqlExpression).getIndex()));
        }
    }

    private void parseOffsetCondition(SelectStatement selectStatement) {
        SQLExpression sqlExpression = this.expressionClauseParser.parse(selectStatement);
        if (null == selectStatement.getLimit()) {
            selectStatement.setLimit(new Limit(false));
        }
        if (sqlExpression instanceof SQLNumberExpression) {
            int offset = ((SQLNumberExpression)sqlExpression).getNumber().intValue();
            selectStatement.getLimit().setOffset(new LimitValue(offset, -1));
            selectStatement.getSqlTokens().add(new OffsetToken(this.lexerEngine.getCurrentToken().getEndPosition() - String.valueOf(offset).length() - this.lexerEngine.getCurrentToken().getLiterals().length(), offset));
        } else if (sqlExpression instanceof SQLPlaceholderExpression) {
            selectStatement.getLimit().setOffset(new LimitValue(-1, ((SQLPlaceholderExpression)sqlExpression).getIndex()));
        }
    }

    protected Keyword[] getCustomizedOtherConditionOperators() {
        return new Keyword[0];
    }

    private void parseOtherCondition(SQLStatement sqlStatement) {
        this.expressionClauseParser.parse(sqlStatement);
    }

    private Optional<Column> find(Tables tables, SQLExpression sqlExpression) {
        if (sqlExpression instanceof SQLPropertyExpression) {
            return this.getColumnWithOwner(tables, (SQLPropertyExpression)sqlExpression);
        }
        if (sqlExpression instanceof SQLIdentifierExpression) {
            return this.getColumnWithoutOwner(tables, (SQLIdentifierExpression)sqlExpression);
        }
        return Optional.absent();
    }

    private Optional<Column> getColumnWithOwner(Tables tables, SQLPropertyExpression propertyExpression) {
        Optional<Table> table = tables.find(SQLUtil.getExactlyValue(propertyExpression.getOwner().getName()));
        return propertyExpression.getOwner() instanceof SQLIdentifierExpression && table.isPresent() ? Optional.of((Object)new Column(SQLUtil.getExactlyValue(propertyExpression.getName()), ((Table)table.get()).getName())) : Optional.absent();
    }

    private Optional<Column> getColumnWithoutOwner(Tables tables, SQLIdentifierExpression identifierExpression) {
        return tables.isSingleTable() ? Optional.of((Object)new Column(SQLUtil.getExactlyValue(identifierExpression.getName()), tables.getSingleTableName())) : Optional.absent();
    }
}

