/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.yaml.sharding;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.api.config.TableRuleConfiguration;
import io.shardingjdbc.core.yaml.sharding.YamlShardingStrategyConfiguration;

public class YamlTableRuleConfiguration {
    private String logicTable;
    private String actualDataNodes;
    private YamlShardingStrategyConfiguration databaseStrategy;
    private YamlShardingStrategyConfiguration tableStrategy;
    private String keyGeneratorColumnName;
    private String keyGeneratorClass;

    public TableRuleConfiguration build() {
        Preconditions.checkNotNull((Object)this.logicTable, (Object)"Logic table cannot be null.");
        TableRuleConfiguration tableRuleConfig = new TableRuleConfiguration();
        tableRuleConfig.setLogicTable(this.logicTable);
        tableRuleConfig.setActualDataNodes(this.actualDataNodes);
        tableRuleConfig.setLogicTable(this.logicTable);
        if (null != this.databaseStrategy) {
            tableRuleConfig.setDatabaseShardingStrategyConfig(this.databaseStrategy.build());
        }
        if (null != this.tableStrategy) {
            tableRuleConfig.setTableShardingStrategyConfig(this.tableStrategy.build());
        }
        tableRuleConfig.setKeyGeneratorClass(this.keyGeneratorClass);
        tableRuleConfig.setKeyGeneratorColumnName(this.keyGeneratorColumnName);
        return tableRuleConfig;
    }

    public String getLogicTable() {
        return this.logicTable;
    }

    public String getActualDataNodes() {
        return this.actualDataNodes;
    }

    public YamlShardingStrategyConfiguration getDatabaseStrategy() {
        return this.databaseStrategy;
    }

    public YamlShardingStrategyConfiguration getTableStrategy() {
        return this.tableStrategy;
    }

    public String getKeyGeneratorColumnName() {
        return this.keyGeneratorColumnName;
    }

    public String getKeyGeneratorClass() {
        return this.keyGeneratorClass;
    }

    public void setLogicTable(String logicTable) {
        this.logicTable = logicTable;
    }

    public void setActualDataNodes(String actualDataNodes) {
        this.actualDataNodes = actualDataNodes;
    }

    public void setDatabaseStrategy(YamlShardingStrategyConfiguration databaseStrategy) {
        this.databaseStrategy = databaseStrategy;
    }

    public void setTableStrategy(YamlShardingStrategyConfiguration tableStrategy) {
        this.tableStrategy = tableStrategy;
    }

    public void setKeyGeneratorColumnName(String keyGeneratorColumnName) {
        this.keyGeneratorColumnName = keyGeneratorColumnName;
    }

    public void setKeyGeneratorClass(String keyGeneratorClass) {
        this.keyGeneratorClass = keyGeneratorClass;
    }
}

