/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dal;

import io.shardingsphere.core.merger.MergeEngine;
import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.merger.dal.show.ShowCreateTableMergedResult;
import io.shardingsphere.core.merger.dal.show.ShowDatabasesMergedResult;
import io.shardingsphere.core.merger.dal.show.ShowOtherMergedResult;
import io.shardingsphere.core.merger.dal.show.ShowTablesMergedResult;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowCreateTableStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowDatabasesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTablesStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.List;

public final class DALMergeEngine
implements MergeEngine {
    private final ShardingRule shardingRule;
    private final List<QueryResult> queryResults;
    private final DALStatement dalStatement;

    @Override
    public MergedResult merge() throws SQLException {
        if (this.dalStatement instanceof ShowDatabasesStatement) {
            return new ShowDatabasesMergedResult();
        }
        if (this.dalStatement instanceof ShowTablesStatement) {
            return new ShowTablesMergedResult(this.shardingRule, this.queryResults);
        }
        if (this.dalStatement instanceof ShowCreateTableStatement) {
            return new ShowCreateTableMergedResult(this.shardingRule, this.queryResults);
        }
        return new ShowOtherMergedResult(this.queryResults.get(0));
    }

    @ConstructorProperties(value={"shardingRule", "queryResults", "dalStatement"})
    public DALMergeEngine(ShardingRule shardingRule, List<QueryResult> queryResults, DALStatement dalStatement) {
        this.shardingRule = shardingRule;
        this.queryResults = queryResults;
        this.dalStatement = dalStatement;
    }
}

