/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dal.show;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.merger.dql.common.MemoryMergedResult;
import io.shardingsphere.core.merger.dql.common.MemoryQueryResultRow;
import io.shardingsphere.core.parsing.SQLParsingEngine;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ShowCreateTableMergedResult
extends MemoryMergedResult {
    private static final Map<String, Integer> LABEL_AND_INDEX_MAP = new HashMap<String, Integer>(2, 1.0f);
    private final ShardingRule shardingRule;
    private final Iterator<MemoryQueryResultRow> memoryResultSetRows;

    public ShowCreateTableMergedResult(ShardingRule shardingRule, List<QueryResult> queryResults) throws SQLException {
        super(LABEL_AND_INDEX_MAP);
        this.shardingRule = shardingRule;
        this.memoryResultSetRows = this.init(queryResults);
    }

    private Iterator<MemoryQueryResultRow> init(List<QueryResult> queryResults) throws SQLException {
        LinkedList<MemoryQueryResultRow> result = new LinkedList<MemoryQueryResultRow>();
        for (QueryResult each : queryResults) {
            while (each.next()) {
                MemoryQueryResultRow memoryResultSetRow = new MemoryQueryResultRow(each);
                String tableName = memoryResultSetRow.getCell(1).toString();
                Optional<TableRule> tableRule = this.shardingRule.tryFindTableRuleByActualTable(tableName);
                if (!tableRule.isPresent()) continue;
                String logicTableName = ((TableRule)tableRule.get()).getLogicTable();
                memoryResultSetRow.setCell(1, logicTableName);
                String createTableDDL = memoryResultSetRow.getCell(2).toString();
                SQLParsingEngine sqlParsingEngine = new SQLParsingEngine(DatabaseType.MySQL, createTableDDL, this.shardingRule, null);
                String actualTableName = sqlParsingEngine.parse(true).getTables().getSingleTableName();
                if (actualTableName.startsWith("`")) {
                    logicTableName = "`" + logicTableName + "`";
                }
                memoryResultSetRow.setCell(2, createTableDDL.replaceFirst(actualTableName, logicTableName));
                result.add(memoryResultSetRow);
            }
        }
        if (!result.isEmpty()) {
            this.setCurrentResultSetRow((MemoryQueryResultRow)result.get(0));
        }
        return result.iterator();
    }

    @Override
    public boolean next() {
        if (this.memoryResultSetRows.hasNext()) {
            this.setCurrentResultSetRow(this.memoryResultSetRows.next());
            return true;
        }
        return false;
    }

    static {
        LABEL_AND_INDEX_MAP.put("Table", 1);
        LABEL_AND_INDEX_MAP.put("Create Table", 2);
    }
}

