/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.alter;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLAlterParser;
import io.shardingsphere.core.parsing.parser.dialect.oracle.sql.OracleAlterParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.sql.PostgreSQLAlterParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerAlterParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.alter.AbstractAlterParser;
import io.shardingsphere.core.rule.ShardingRule;

public final class AlterParserFactory {
    public static AbstractAlterParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLAlterParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleAlterParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerAlterParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLAlterParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private AlterParserFactory() {
    }
}

