/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.strategy.hint;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.api.algorithm.sharding.ShardingValue;
import io.shardingsphere.core.api.algorithm.sharding.hint.HintShardingAlgorithm;
import io.shardingsphere.core.api.config.strategy.HintShardingStrategyConfiguration;
import io.shardingsphere.core.routing.strategy.ShardingStrategy;
import java.util.Collection;
import java.util.TreeSet;

public final class HintShardingStrategy
implements ShardingStrategy {
    private final Collection<String> shardingColumns;
    private final HintShardingAlgorithm shardingAlgorithm;

    public HintShardingStrategy(HintShardingStrategyConfiguration hintShardingStrategyConfig) {
        Preconditions.checkNotNull((Object)hintShardingStrategyConfig.getShardingAlgorithm(), (Object)"Sharding algorithm cannot be null.");
        this.shardingColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.shardingAlgorithm = hintShardingStrategyConfig.getShardingAlgorithm();
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<ShardingValue> shardingValues) {
        Collection<String> shardingResult = this.shardingAlgorithm.doSharding(availableTargetNames, shardingValues.iterator().next());
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(shardingResult);
        return result;
    }

    @Override
    public Collection<String> getShardingColumns() {
        return this.shardingColumns;
    }
}

