/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type;

import com.google.common.base.Optional;
import io.shardingsphere.core.routing.type.RoutingTable;
import io.shardingsphere.core.routing.type.TableUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TableUnits {
    private final List<TableUnit> tableUnits = new LinkedList<TableUnit>();

    public Collection<String> getDataSourceNames() {
        HashSet<String> result = new HashSet<String>(this.tableUnits.size(), 1.0f);
        for (TableUnit each : this.tableUnits) {
            result.add(each.getDataSourceName());
        }
        return result;
    }

    public Optional<RoutingTable> findRoutingTable(String dataSourceName, String actualTableName) {
        for (TableUnit each : this.tableUnits) {
            Optional<RoutingTable> result = each.findRoutingTable(dataSourceName, actualTableName);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.absent();
    }

    public List<Set<String>> getActualTableNameGroups(String dataSourceName, Set<String> logicTableNames) {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        for (String logicTableName : logicTableNames) {
            Set<String> actualTableNames = this.getActualTableNames(dataSourceName, logicTableName);
            if (actualTableNames.isEmpty()) continue;
            result.add(actualTableNames);
        }
        return result;
    }

    private Set<String> getActualTableNames(String dataSourceName, String logicTableName) {
        HashSet<String> result = new HashSet<String>(this.tableUnits.size(), 1.0f);
        for (TableUnit each : this.tableUnits) {
            result.addAll(each.getActualTableNames(dataSourceName, logicTableName));
        }
        return result;
    }

    public Map<String, Set<String>> getDataSourceLogicTablesMap(Collection<String> dataSourceNames) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String each : dataSourceNames) {
            Set<String> logicTableNames = this.getLogicTableNames(each);
            if (logicTableNames.isEmpty()) continue;
            result.put(each, logicTableNames);
        }
        return result;
    }

    private Set<String> getLogicTableNames(String dataSourceName) {
        HashSet<String> result = new HashSet<String>(this.tableUnits.size(), 1.0f);
        for (TableUnit each : this.tableUnits) {
            if (!each.getDataSourceName().equalsIgnoreCase(dataSourceName)) continue;
            result.addAll(each.getLogicTableNames(dataSourceName));
        }
        return result;
    }

    public List<TableUnit> getTableUnits() {
        return this.tableUnits;
    }

    public String toString() {
        return "TableUnits(tableUnits=" + this.getTableUnits() + ")";
    }
}

