/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.util;

import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.SQLExecutionUnit;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLLogger {
    private static final Logger log = LoggerFactory.getLogger((String)"Sharding-Sphere-SQL");

    public static void logSQL(String logicSQL, SQLStatement sqlStatement, Collection<SQLExecutionUnit> sqlExecutionUnits) {
        SQLLogger.log("Logic SQL: {}", logicSQL);
        SQLLogger.log("SQLStatement: {}", sqlStatement);
        for (SQLExecutionUnit each : sqlExecutionUnits) {
            if (each.getSqlUnit().getParameterSets().get(0).isEmpty()) {
                SQLLogger.log("Actual SQL: {} ::: {}", each.getDataSource(), each.getSqlUnit().getSql());
                continue;
            }
            SQLLogger.log("Actual SQL: {} ::: {} ::: {}", each.getDataSource(), each.getSqlUnit().getSql(), each.getSqlUnit().getParameterSets());
        }
    }

    private static void log(String pattern, Object ... arguments) {
        log.info(pattern, arguments);
    }

    private SQLLogger() {
    }
}

