/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowMessages;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;

final class ALPNOfferedClientHelloExplorer {
    private static final int RECORD_HEADER_SIZE = 5;

    private ALPNOfferedClientHelloExplorer() {
    }

    static List<Integer> parseClientHello(ByteBuffer source) throws SSLException {
        ByteBuffer input = source.duplicate();
        if (input.remaining() < 5) {
            throw new BufferUnderflowException();
        }
        byte firstByte = input.get();
        byte secondByte = input.get();
        byte thirdByte = input.get();
        if ((firstByte & 0x80) != 0 && thirdByte == 1) {
            return null;
        }
        if (firstByte == 22 && secondByte == 3 && thirdByte >= 1 && thirdByte <= 3) {
            return ALPNOfferedClientHelloExplorer.exploreTLSRecord(input, firstByte, secondByte, thirdByte);
        }
        return null;
    }

    private static List<Integer> exploreTLSRecord(ByteBuffer input, byte firstByte, byte secondByte, byte thirdByte) throws SSLException {
        if (firstByte != 22) {
            throw UndertowMessages.MESSAGES.notHandshakeRecord();
        }
        int recordLength = ALPNOfferedClientHelloExplorer.getInt16(input);
        if (recordLength > input.remaining()) {
            throw new BufferUnderflowException();
        }
        try {
            return ALPNOfferedClientHelloExplorer.exploreHandshake(input, secondByte, thirdByte, recordLength);
        }
        catch (BufferUnderflowException ignored) {
            throw UndertowMessages.MESSAGES.invalidHandshakeRecord();
        }
    }

    private static List<Integer> exploreHandshake(ByteBuffer input, byte recordMajorVersion, byte recordMinorVersion, int recordLength) throws SSLException {
        byte handshakeType = input.get();
        if (handshakeType != 1) {
            throw UndertowMessages.MESSAGES.expectedClientHello();
        }
        int handshakeLength = ALPNOfferedClientHelloExplorer.getInt24(input);
        if (handshakeLength > recordLength - 4) {
            throw UndertowMessages.MESSAGES.multiRecordSSLHandshake();
        }
        input = input.duplicate();
        input.limit(handshakeLength + input.position());
        return ALPNOfferedClientHelloExplorer.exploreRecord(input);
    }

    private static List<Integer> exploreRecord(ByteBuffer input) throws SSLException {
        byte helloMajorVersion = input.get();
        byte helloMinorVersion = input.get();
        if (helloMajorVersion != 3 && helloMinorVersion != 3) {
            return null;
        }
        for (int i = 0; i < 32; ++i) {
            byte by = input.get();
        }
        ALPNOfferedClientHelloExplorer.processByteVector8(input);
        int int16 = ALPNOfferedClientHelloExplorer.getInt16(input);
        ArrayList<Integer> ciphers = new ArrayList<Integer>();
        for (int i = 0; i < int16; i += 2) {
            ciphers.add(ALPNOfferedClientHelloExplorer.getInt16(input));
        }
        ALPNOfferedClientHelloExplorer.processByteVector8(input);
        if (input.remaining() > 0) {
            return ALPNOfferedClientHelloExplorer.exploreExtensions(input, ciphers);
        }
        return null;
    }

    private static List<Integer> exploreExtensions(ByteBuffer input, List<Integer> ciphers) throws SSLException {
        int extLen;
        for (int length = ALPNOfferedClientHelloExplorer.getInt16(input); length > 0; length -= extLen + 4) {
            int extType = ALPNOfferedClientHelloExplorer.getInt16(input);
            extLen = ALPNOfferedClientHelloExplorer.getInt16(input);
            if (extType == 16) {
                return ciphers;
            }
            ALPNOfferedClientHelloExplorer.processByteVector(input, extLen);
        }
        return null;
    }

    private static int getInt8(ByteBuffer input) {
        return input.get();
    }

    private static int getInt16(ByteBuffer input) {
        return (input.get() & 0xFF) << 8 | input.get() & 0xFF;
    }

    private static int getInt24(ByteBuffer input) {
        return (input.get() & 0xFF) << 16 | (input.get() & 0xFF) << 8 | input.get() & 0xFF;
    }

    private static void processByteVector8(ByteBuffer input) {
        int int8 = ALPNOfferedClientHelloExplorer.getInt8(input);
        ALPNOfferedClientHelloExplorer.processByteVector(input, int8);
    }

    private static void processByteVector(ByteBuffer input, int length) {
        for (int i = 0; i < length; ++i) {
            byte by = input.get();
        }
    }

    private static void processByteVector16(ByteBuffer input) {
        int int16 = ALPNOfferedClientHelloExplorer.getInt16(input);
        ALPNOfferedClientHelloExplorer.processByteVector(input, int16);
    }
}

