/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ServiceHelper;
import io.vertx.core.spi.FutureFactory;
import java.util.function.Function;

@VertxGen
public interface Future<T>
extends AsyncResult<T>,
Handler<AsyncResult<T>> {
    @GenIgnore
    public static final FutureFactory factory = ServiceHelper.loadFactory(FutureFactory.class);

    public static <T> Future<T> future(Handler<Promise<T>> handler) {
        Promise promise = Promise.promise();
        try {
            handler.handle(promise);
        }
        catch (Throwable e) {
            promise.tryFail(e);
        }
        return promise.future();
    }

    @Deprecated
    public static <T> Future<T> future() {
        return factory.future();
    }

    public static <T> Future<T> succeededFuture() {
        return factory.succeededFuture();
    }

    public static <T> Future<T> succeededFuture(T result) {
        if (result == null) {
            return factory.succeededFuture();
        }
        return factory.succeededFuture(result);
    }

    public static <T> Future<T> failedFuture(Throwable t) {
        return factory.failedFuture(t);
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        return factory.failureFuture(failureMessage);
    }

    public boolean isComplete();

    @Deprecated
    @Fluent
    default public Future<T> setHandler(Handler<AsyncResult<T>> handler) {
        return this.onComplete(handler);
    }

    @Fluent
    public Future<T> onComplete(Handler<AsyncResult<T>> var1);

    @Fluent
    default public Future<T> onSuccess(Handler<T> handler) {
        return this.onComplete(ar -> {
            if (ar.succeeded()) {
                handler.handle(ar.result());
            }
        });
    }

    @Fluent
    default public Future<T> onFailure(Handler<Throwable> handler) {
        return this.onComplete(ar -> {
            if (ar.failed()) {
                handler.handle(ar.cause());
            }
        });
    }

    @Deprecated
    public void complete(T var1);

    @Deprecated
    public void complete();

    @Deprecated
    public void fail(Throwable var1);

    @Deprecated
    public void fail(String var1);

    @Deprecated
    public boolean tryComplete(T var1);

    @Deprecated
    public boolean tryComplete();

    @Deprecated
    public boolean tryFail(Throwable var1);

    @Deprecated
    public boolean tryFail(String var1);

    @Override
    public T result();

    @Override
    public Throwable cause();

    @Override
    public boolean succeeded();

    @Override
    public boolean failed();

    default public <U> Future<U> flatMap(Function<T, Future<U>> mapper) {
        return this.compose(mapper);
    }

    @GenIgnore
    @Deprecated
    default public <U> Future<U> compose(Handler<T> handler, Future<U> next) {
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                try {
                    handler.handle(ar.result());
                }
                catch (Throwable err) {
                    if (next.isComplete()) {
                        throw err;
                    }
                    next.fail(err);
                }
            } else {
                next.fail(ar.cause());
            }
        });
        return next;
    }

    default public <U> Future<U> compose(Function<T, Future<U>> mapper) {
        return this.compose(mapper, Future::failedFuture);
    }

    default public <U> Future<U> compose(Function<T, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
        if (successMapper == null) {
            throw new NullPointerException();
        }
        if (failureMapper == null) {
            throw new NullPointerException();
        }
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                Future apply;
                try {
                    apply = (Future)successMapper.apply(ar.result());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                apply.onComplete(ret);
            } else {
                Future apply;
                try {
                    apply = (Future)failureMapper.apply(ar.cause());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                apply.onComplete(ret);
            }
        });
        return ret.future();
    }

    @Override
    default public <U> Future<U> map(Function<T, U> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                Object mapped;
                try {
                    mapped = mapper.apply(ar.result());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                ret.complete(mapped);
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret.future();
    }

    @Override
    default public <V> Future<V> map(V value) {
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(value);
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret.future();
    }

    @Override
    default public <V> Future<V> mapEmpty() {
        return (Future)AsyncResult.super.mapEmpty();
    }

    @Override
    @GenIgnore
    public void handle(AsyncResult<T> var1);

    @Deprecated
    @CacheReturn
    default public Handler<AsyncResult<T>> completer() {
        return this;
    }

    default public Future<T> recover(Function<Throwable, Future<T>> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                Future mapped;
                try {
                    mapped = (Future)mapper.apply(ar.cause());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                mapped.onComplete(ret);
            }
        });
        return ret.future();
    }

    @Override
    default public Future<T> otherwise(Function<Throwable, T> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                Object value;
                try {
                    value = mapper.apply(ar.cause());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                ret.complete(value);
            }
        });
        return ret.future();
    }

    @Override
    default public Future<T> otherwise(T value) {
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                ret.complete(value);
            }
        });
        return ret.future();
    }

    @Override
    default public Future<T> otherwiseEmpty() {
        return (Future)AsyncResult.super.otherwiseEmpty();
    }
}

