/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;

@DataObject
public class MqttServerOptions
extends NetServerOptions {
    public static final int DEFAULT_PORT = 1883;
    public static final int DEFAULT_TLS_PORT = 8883;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = -1;
    public static final int DEFAULT_TIMEOUT_ON_CONNECT = 90;
    private int maxMessageSize;
    private boolean isAutoClientId;
    private int timeoutOnConnect;

    public MqttServerOptions() {
        this.setPort(1883);
        this.maxMessageSize = -1;
        this.isAutoClientId = true;
        this.timeoutOnConnect = 90;
    }

    public MqttServerOptions(JsonObject json) {
        super(json);
        this.setPort(json.getInteger("port", Integer.valueOf(1883)));
        this.maxMessageSize = json.getInteger("maxMessageSize", Integer.valueOf(-1));
        this.isAutoClientId = json.getBoolean("isAutoClientId", Boolean.valueOf(true));
        this.timeoutOnConnect = json.getInteger("timeoutOnConnect", Integer.valueOf(90));
        if (this.maxMessageSize > 0 && this.getReceiveBufferSize() > 0) {
            Arguments.require((this.getReceiveBufferSize() >= this.maxMessageSize ? 1 : 0) != 0, (String)"Receiver buffer size can't be lower than max message size");
        }
    }

    public MqttServerOptions(MqttServerOptions other) {
        super((NetServerOptions)other);
    }

    public MqttServerOptions setPort(int port) {
        super.setPort(port);
        return this;
    }

    public MqttServerOptions setHost(String host) {
        super.setHost(host);
        return this;
    }

    public MqttServerOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public MqttServerOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    public MqttServerOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    public MqttServerOptions setPfxKeyCertOptions(PfxOptions options) {
        super.setPfxKeyCertOptions(options);
        return this;
    }

    public MqttServerOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        super.setPemKeyCertOptions(options);
        return this;
    }

    public MqttServerOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    public MqttServerOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    public MqttServerOptions setPemTrustOptions(PemTrustOptions options) {
        super.setPemTrustOptions(options);
        return this;
    }

    public MqttServerOptions setPfxTrustOptions(PfxOptions options) {
        super.setPfxTrustOptions(options);
        return this;
    }

    public MqttServerOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    public MqttServerOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public MqttServerOptions addCrlPath(String crlPath) throws NullPointerException {
        super.addCrlPath(crlPath);
        return this;
    }

    public MqttServerOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        super.addCrlValue(crlValue);
        return this;
    }

    public MqttServerOptions setReceiveBufferSize(int receiveBufferSize) {
        if (this.maxMessageSize > 0 && receiveBufferSize > 0) {
            Arguments.require((receiveBufferSize >= this.maxMessageSize ? 1 : 0) != 0, (String)"Receiver buffer size can't be lower than max message size");
        }
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public MqttServerOptions setMaxMessageSize(int maxMessageSize) {
        Arguments.require((maxMessageSize > 0 || maxMessageSize == -1 ? 1 : 0) != 0, (String)"maxMessageSize must be > 0");
        if (maxMessageSize > 0 && this.getReceiveBufferSize() > 0) {
            Arguments.require((this.getReceiveBufferSize() >= maxMessageSize ? 1 : 0) != 0, (String)"Receiver buffer size can't be lower than max message size");
        }
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public MqttServerOptions setAutoClientId(boolean isAutoClientId) {
        this.isAutoClientId = isAutoClientId;
        return this;
    }

    public boolean isAutoClientId() {
        return this.isAutoClientId;
    }

    public MqttServerOptions setTimeoutOnConnect(int timeoutOnConnect) {
        this.timeoutOnConnect = timeoutOnConnect;
        return this;
    }

    public int timeoutOnConnect() {
        return this.timeoutOnConnect;
    }
}

