/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.impl.MqttClientImpl;
import io.vertx.mqtt.messages.MqttConnAckMessage;
import io.vertx.mqtt.messages.MqttSubAckMessage;

public class MqttClientConnection {
    private static final Logger log = LoggerFactory.getLogger(MqttClientConnection.class);
    private final NetSocketInternal so;
    private final ChannelHandlerContext chctx;
    private MqttClientOptions options;
    private MqttClientImpl client;

    MqttClientConnection(MqttClientImpl client, NetSocketInternal so, MqttClientOptions options) {
        this.so = so;
        this.chctx = so.channelHandlerContext();
        this.client = client;
        this.options = options;
    }

    synchronized void handleMessage(Object msg) {
        if (msg instanceof MqttMessage) {
            MqttMessage mqttMessage = (MqttMessage)msg;
            DecoderResult result = mqttMessage.decoderResult();
            if (result.isFailure()) {
                this.chctx.pipeline().fireExceptionCaught(result.cause());
                return;
            }
            if (!result.isFinished()) {
                this.chctx.pipeline().fireExceptionCaught((Throwable)new Exception("Unfinished message"));
                return;
            }
            log.debug((Object)String.format("Incoming packet %s", msg));
            switch (mqttMessage.fixedHeader().messageType()) {
                case CONNACK: {
                    io.netty.handler.codec.mqtt.MqttConnAckMessage connack = (io.netty.handler.codec.mqtt.MqttConnAckMessage)mqttMessage;
                    MqttConnAckMessage mqttConnAckMessage = MqttConnAckMessage.create(connack.variableHeader().connectReturnCode(), connack.variableHeader().isSessionPresent());
                    this.handleConnack(mqttConnAckMessage);
                    break;
                }
                case PUBLISH: {
                    MqttPublishMessage publish = (MqttPublishMessage)mqttMessage;
                    ByteBuf newBuf = VertxHandler.safeBuffer((ByteBuf)publish.payload(), (ByteBufAllocator)this.chctx.alloc());
                    io.vertx.mqtt.messages.MqttPublishMessage mqttPublishMessage = io.vertx.mqtt.messages.MqttPublishMessage.create(publish.variableHeader().messageId(), publish.fixedHeader().qosLevel(), publish.fixedHeader().isDup(), publish.fixedHeader().isRetain(), publish.variableHeader().topicName(), newBuf);
                    this.handlePublish(mqttPublishMessage);
                    break;
                }
                case PUBACK: {
                    this.handlePuback(((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId());
                    break;
                }
                case PUBREC: {
                    this.handlePubrec(((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId());
                    break;
                }
                case PUBREL: {
                    this.handlePubrel(((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId());
                    break;
                }
                case PUBCOMP: {
                    this.handlePubcomp(((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId());
                    break;
                }
                case SUBACK: {
                    io.netty.handler.codec.mqtt.MqttSubAckMessage unsuback = (io.netty.handler.codec.mqtt.MqttSubAckMessage)mqttMessage;
                    MqttSubAckMessage mqttSubAckMessage = MqttSubAckMessage.create(unsuback.variableHeader().messageId(), unsuback.payload().grantedQoSLevels());
                    this.handleSuback(mqttSubAckMessage);
                    break;
                }
                case UNSUBACK: {
                    this.handleUnsuback(((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId());
                    break;
                }
                case PINGRESP: {
                    this.handlePingresp();
                    break;
                }
                default: {
                    this.chctx.pipeline().fireExceptionCaught((Throwable)new Exception("Wrong message type " + msg.getClass().getName()));
                    break;
                }
            }
        } else {
            this.chctx.pipeline().fireExceptionCaught((Throwable)new Exception("Wrong message type"));
        }
    }

    private synchronized void handlePingresp() {
        this.client.handlePingresp();
    }

    private synchronized void handleUnsuback(int unsubackMessageId) {
        this.client.handleUnsuback(unsubackMessageId);
    }

    private synchronized void handleSuback(MqttSubAckMessage msg) {
        this.client.handleSuback(msg);
    }

    private synchronized void handlePubcomp(int pubcompMessageId) {
        this.client.handlePubcomp(pubcompMessageId);
    }

    private synchronized void handlePuback(int pubackMessageId) {
        this.client.handlePuback(pubackMessageId);
    }

    private synchronized void handlePubrel(int pubrelMessageId) {
        this.client.handlePubrel(pubrelMessageId);
    }

    private synchronized void handlePublish(io.vertx.mqtt.messages.MqttPublishMessage msg) {
        this.client.handlePublish(msg);
    }

    private synchronized void handlePubrec(int pubrecMessageId) {
        this.client.handlePubrec(pubrecMessageId);
    }

    private synchronized void handleConnack(MqttConnAckMessage msg) {
        this.client.handleConnack(msg);
    }

    void close() {
        this.so.close();
    }

    void writeMessage(MqttMessage mqttMessage) {
        this.so.writeMessage((Object)mqttMessage);
    }
}

