/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.impl;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttServer;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.mqtt.impl.MqttConnection;

public class MqttServerImpl
implements MqttServer {
    private final NetServer server;
    private Handler<MqttEndpoint> endpointHandler;
    private Handler<Throwable> exceptionHandler;
    private MqttServerOptions options;

    public MqttServerImpl(Vertx vertx, MqttServerOptions options) {
        this.server = vertx.createNetServer((NetServerOptions)options);
        this.options = options;
    }

    @Override
    public MqttServer listen() {
        return this.listen((Handler<AsyncResult<MqttServer>>)((Handler)ar -> {}));
    }

    @Override
    public MqttServer listen(int port, String host) {
        return this.listen(port, host, (Handler<AsyncResult<MqttServer>>)((Handler)ar -> {}));
    }

    @Override
    public MqttServer listen(int port) {
        return this.listen(port, (Handler<AsyncResult<MqttServer>>)((Handler)ar -> {}));
    }

    @Override
    public MqttServer listen(int port, Handler<AsyncResult<MqttServer>> listenHandler) {
        return this.listen(port, this.options.getHost(), listenHandler);
    }

    @Override
    public MqttServer listen(Handler<AsyncResult<MqttServer>> listenHandler) {
        return this.listen(this.options.getPort(), listenHandler);
    }

    @Override
    public MqttServer listen(int port, String host, Handler<AsyncResult<MqttServer>> listenHandler) {
        Handler<MqttEndpoint> h1 = this.endpointHandler;
        Handler<Throwable> h2 = this.exceptionHandler;
        this.server.connectHandler(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            ChannelPipeline pipeline = soi.channelHandlerContext().pipeline();
            this.initChannel(pipeline);
            MqttConnection conn = new MqttConnection(soi, this.options);
            soi.messageHandler(msg -> conn.handleMessage(msg));
            conn.init(h1, h2);
        });
        this.server.listen(port, host, ar -> listenHandler.handle((Object)ar.map((Object)this)));
        return this;
    }

    @Override
    public synchronized MqttServer endpointHandler(Handler<MqttEndpoint> handler) {
        this.endpointHandler = handler;
        return this;
    }

    @Override
    public synchronized MqttServer exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public int actualPort() {
        return this.server.actualPort();
    }

    @Override
    public void close() {
        this.server.close();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.server.close(completionHandler);
    }

    private void initChannel(ChannelPipeline pipeline) {
        pipeline.addBefore("handler", "mqttEncoder", (ChannelHandler)MqttEncoder.INSTANCE);
        if (this.options.getMaxMessageSize() > 0) {
            pipeline.addBefore("handler", "mqttDecoder", (ChannelHandler)new MqttDecoder(this.options.getMaxMessageSize()));
        } else {
            pipeline.addBefore("handler", "mqttDecoder", (ChannelHandler)new MqttDecoder());
        }
        pipeline.addBefore("handler", "idle", (ChannelHandler)new IdleStateHandler(this.options.timeoutOnConnect(), 0, 0));
        pipeline.addBefore("handler", "timeoutOnConnect", (ChannelHandler)new ChannelDuplexHandler(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                IdleStateEvent e;
                if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
                    ctx.channel().close();
                }
            }
        });
    }
}

