/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.mqtt;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import io.vertx.reactivex.mqtt.MqttEndpoint;

@RxGen(value=io.vertx.mqtt.MqttServer.class)
public class MqttServer {
    public static final TypeArg<MqttServer> __TYPE_ARG = new TypeArg(obj -> new MqttServer((io.vertx.mqtt.MqttServer)obj), MqttServer::getDelegate);
    private final io.vertx.mqtt.MqttServer delegate;

    public MqttServer(io.vertx.mqtt.MqttServer delegate) {
        this.delegate = delegate;
    }

    public io.vertx.mqtt.MqttServer getDelegate() {
        return this.delegate;
    }

    public static MqttServer create(Vertx vertx, MqttServerOptions options) {
        MqttServer ret = MqttServer.newInstance(io.vertx.mqtt.MqttServer.create(vertx.getDelegate(), options));
        return ret;
    }

    public static MqttServer create(Vertx vertx) {
        MqttServer ret = MqttServer.newInstance(io.vertx.mqtt.MqttServer.create(vertx.getDelegate()));
        return ret;
    }

    public MqttServer listen() {
        this.delegate.listen();
        return this;
    }

    public MqttServer listen(int port, String host) {
        this.delegate.listen(port, host);
        return this;
    }

    public MqttServer listen(int port, String host, final Handler<AsyncResult<MqttServer>> listenHandler) {
        this.delegate.listen(port, host, new Handler<AsyncResult<io.vertx.mqtt.MqttServer>>(){

            public void handle(AsyncResult<io.vertx.mqtt.MqttServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)MqttServer.newInstance((io.vertx.mqtt.MqttServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<MqttServer> rxListen(int port, String host) {
        return new AsyncResultSingle(handler -> this.listen(port, host, (Handler<AsyncResult<MqttServer>>)handler));
    }

    public MqttServer listen(int port) {
        this.delegate.listen(port);
        return this;
    }

    public MqttServer listen(int port, final Handler<AsyncResult<MqttServer>> listenHandler) {
        this.delegate.listen(port, new Handler<AsyncResult<io.vertx.mqtt.MqttServer>>(){

            public void handle(AsyncResult<io.vertx.mqtt.MqttServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)MqttServer.newInstance((io.vertx.mqtt.MqttServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<MqttServer> rxListen(int port) {
        return new AsyncResultSingle(handler -> this.listen(port, (Handler<AsyncResult<MqttServer>>)handler));
    }

    public MqttServer listen(final Handler<AsyncResult<MqttServer>> listenHandler) {
        this.delegate.listen(new Handler<AsyncResult<io.vertx.mqtt.MqttServer>>(){

            public void handle(AsyncResult<io.vertx.mqtt.MqttServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)MqttServer.newInstance((io.vertx.mqtt.MqttServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<MqttServer> rxListen() {
        return new AsyncResultSingle(handler -> this.listen((Handler<AsyncResult<MqttServer>>)handler));
    }

    public MqttServer endpointHandler(final Handler<MqttEndpoint> handler) {
        this.delegate.endpointHandler(new Handler<io.vertx.mqtt.MqttEndpoint>(){

            public void handle(io.vertx.mqtt.MqttEndpoint event) {
                handler.handle((Object)MqttEndpoint.newInstance(event));
            }
        });
        return this;
    }

    public MqttServer exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public Completable rxClose() {
        return new AsyncResultCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    public static MqttServer newInstance(io.vertx.mqtt.MqttServer arg) {
        return arg != null ? new MqttServer(arg) : null;
    }
}

