/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.mqtt.messages.MqttConnAckMessage;
import io.vertx.rxjava.mqtt.messages.MqttPublishMessage;
import io.vertx.rxjava.mqtt.messages.MqttSubAckMessage;
import java.util.Map;
import rx.Single;

@RxGen(value=io.vertx.mqtt.MqttClient.class)
public class MqttClient {
    public static final TypeArg<MqttClient> __TYPE_ARG = new TypeArg(obj -> new MqttClient((io.vertx.mqtt.MqttClient)obj), MqttClient::getDelegate);
    private final io.vertx.mqtt.MqttClient delegate;

    public MqttClient(io.vertx.mqtt.MqttClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.mqtt.MqttClient getDelegate() {
        return this.delegate;
    }

    public static MqttClient create(Vertx vertx, MqttClientOptions options) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create(vertx.getDelegate(), options));
        return ret;
    }

    public static MqttClient create(Vertx vertx) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create(vertx.getDelegate()));
        return ret;
    }

    public MqttClient connect() {
        this.delegate.connect();
        return this;
    }

    public MqttClient connect(final Handler<AsyncResult<MqttConnAckMessage>> connectHandler) {
        this.delegate.connect(new Handler<AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage>>(){

            public void handle(AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<MqttConnAckMessage> rxConnect() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.connect((Handler<AsyncResult<MqttConnAckMessage>>)fut)));
    }

    public MqttClient disconnect() {
        this.delegate.disconnect();
        return this;
    }

    public MqttClient disconnect(Handler<AsyncResult<Void>> disconnectHandler) {
        this.delegate.disconnect(disconnectHandler);
        return this;
    }

    public Single<Void> rxDisconnect() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.disconnect((Handler<AsyncResult<Void>>)fut)));
    }

    public MqttClient publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain);
        return this;
    }

    public MqttClient publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, Handler<AsyncResult<Integer>> publishSentHandler) {
        this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler);
        return this;
    }

    public Single<Integer> rxPublish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.publish(topic, payload, qosLevel, isDup, isRetain, (Handler<AsyncResult<Integer>>)fut)));
    }

    public MqttClient publishCompleteHandler(Handler<Integer> publishCompleteHandler) {
        this.delegate.publishCompleteHandler(publishCompleteHandler);
        return this;
    }

    public MqttClient publishHandler(final Handler<MqttPublishMessage> publishHandler) {
        this.delegate.publishHandler(new Handler<io.vertx.mqtt.messages.MqttPublishMessage>(){

            public void handle(io.vertx.mqtt.messages.MqttPublishMessage event) {
                publishHandler.handle((Object)MqttPublishMessage.newInstance(event));
            }
        });
        return this;
    }

    public MqttClient subscribeCompleteHandler(final Handler<MqttSubAckMessage> subscribeCompleteHandler) {
        this.delegate.subscribeCompleteHandler(new Handler<io.vertx.mqtt.messages.MqttSubAckMessage>(){

            public void handle(io.vertx.mqtt.messages.MqttSubAckMessage event) {
                subscribeCompleteHandler.handle((Object)MqttSubAckMessage.newInstance(event));
            }
        });
        return this;
    }

    public MqttClient subscribe(String topic, int qos) {
        this.delegate.subscribe(topic, qos);
        return this;
    }

    public MqttClient subscribe(String topic, int qos, Handler<AsyncResult<Integer>> subscribeSentHandler) {
        this.delegate.subscribe(topic, qos, subscribeSentHandler);
        return this;
    }

    public Single<Integer> rxSubscribe(String topic, int qos) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.subscribe(topic, qos, (Handler<AsyncResult<Integer>>)fut)));
    }

    public MqttClient subscribe(Map<String, Integer> topics) {
        this.delegate.subscribe(topics);
        return this;
    }

    public MqttClient subscribe(Map<String, Integer> topics, Handler<AsyncResult<Integer>> subscribeSentHandler) {
        this.delegate.subscribe(topics, subscribeSentHandler);
        return this;
    }

    public Single<Integer> rxSubscribe(Map<String, Integer> topics) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.subscribe(topics, (Handler<AsyncResult<Integer>>)fut)));
    }

    public MqttClient unsubscribeCompleteHandler(Handler<Integer> unsubscribeCompleteHandler) {
        this.delegate.unsubscribeCompleteHandler(unsubscribeCompleteHandler);
        return this;
    }

    public MqttClient unsubscribe(String topic) {
        this.delegate.unsubscribe(topic);
        return this;
    }

    public MqttClient unsubscribe(String topic, Handler<AsyncResult<Integer>> unsubscribeSentHandler) {
        this.delegate.unsubscribe(topic, unsubscribeSentHandler);
        return this;
    }

    public Single<Integer> rxUnsubscribe(String topic) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.unsubscribe(topic, (Handler<AsyncResult<Integer>>)fut)));
    }

    public MqttClient pingResponseHandler(Handler<Void> pingResponseHandler) {
        this.delegate.pingResponseHandler(pingResponseHandler);
        return this;
    }

    public MqttClient exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public MqttClient closeHandler(Handler<Void> closeHandler) {
        this.delegate.closeHandler(closeHandler);
        return this;
    }

    public MqttClient ping() {
        this.delegate.ping();
        return this;
    }

    public String clientId() {
        String ret = this.delegate.clientId();
        return ret;
    }

    public static MqttClient newInstance(io.vertx.mqtt.MqttClient arg) {
        return arg != null ? new MqttClient(arg) : null;
    }
}

