/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.mysqlclient.MySQLAuthOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLSetOption;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLConnectionFactory;
import io.vertx.mysqlclient.impl.command.ChangeUserCommand;
import io.vertx.mysqlclient.impl.command.DebugCommand;
import io.vertx.mysqlclient.impl.command.InitDbCommand;
import io.vertx.mysqlclient.impl.command.PingCommand;
import io.vertx.mysqlclient.impl.command.ResetConnectionCommand;
import io.vertx.mysqlclient.impl.command.SetOptionCommand;
import io.vertx.mysqlclient.impl.command.StatisticsCommand;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class MySQLConnectionImpl
extends SqlConnectionImpl<MySQLConnectionImpl>
implements MySQLConnection {
    private final MySQLConnectionFactory factory;

    public static Future<MySQLConnection> connect(ContextInternal ctx, MySQLConnectOptions options) {
        MySQLConnectionFactory client;
        if (options.isUsingDomainSocket() && !ctx.owner().isNativeTransportEnabled()) {
            return ctx.failedFuture("Native transport is not available");
        }
        try {
            client = new MySQLConnectionFactory(ctx, options);
        }
        catch (Exception e) {
            return ctx.failedFuture((Throwable)e);
        }
        ctx.addCloseHook((Closeable)client);
        QueryTracer tracer = ctx.tracer() == null ? null : new QueryTracer(ctx.tracer(), (SqlConnectOptions)options);
        PromiseInternal promise = ctx.promise();
        ctx.emit(arg_0 -> MySQLConnectionImpl.lambda$connect$0(client, ctx, tracer, (Promise)promise, arg_0));
        return promise.future();
    }

    private static void connect(MySQLConnectionFactory client, ContextInternal ctx, QueryTracer tracer, ClientMetrics metrics, Promise<MySQLConnection> promise) {
        client.connect().map(conn -> {
            MySQLConnectionImpl mySQLConnection = new MySQLConnectionImpl(client, ctx, (Connection)conn, tracer, metrics);
            conn.init((Connection.Holder)mySQLConnection);
            return mySQLConnection;
        }).onComplete(promise);
    }

    public MySQLConnectionImpl(MySQLConnectionFactory factory, ContextInternal context, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(context, conn, tracer, metrics);
        this.factory = factory;
    }

    @Override
    public MySQLConnection ping(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.ping();
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> ping() {
        PromiseInternal promise = this.promise();
        this.schedule(new PingCommand(), (Promise)promise);
        return promise.future();
    }

    @Override
    public MySQLConnection specifySchema(String schemaName, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.specifySchema(schemaName);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> specifySchema(String schemaName) {
        PromiseInternal promise = this.promise();
        this.schedule(new InitDbCommand(schemaName), (Promise)promise);
        return promise.future();
    }

    @Override
    public MySQLConnection getInternalStatistics(Handler<AsyncResult<String>> handler) {
        Future<String> fut = this.getInternalStatistics();
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<String> getInternalStatistics() {
        PromiseInternal promise = this.promise();
        this.schedule(new StatisticsCommand(), (Promise)promise);
        return promise.future();
    }

    @Override
    public MySQLConnection setOption(MySQLSetOption option, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.setOption(option);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> setOption(MySQLSetOption option) {
        PromiseInternal promise = this.promise();
        this.schedule(new SetOptionCommand(option), (Promise)promise);
        return promise.future();
    }

    @Override
    public MySQLConnection resetConnection(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.resetConnection();
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> resetConnection() {
        PromiseInternal promise = this.promise();
        this.schedule(new ResetConnectionCommand(), (Promise)promise);
        return promise.future();
    }

    @Override
    public MySQLConnection debug(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.debug();
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> debug() {
        PromiseInternal promise = this.promise();
        this.schedule(new DebugCommand(), (Promise)promise);
        return promise.future();
    }

    @Override
    public MySQLConnection changeUser(MySQLAuthOptions options, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.changeUser(options);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> changeUser(MySQLAuthOptions options) {
        String charset;
        MySQLCollation collation = options.getCollation() != null ? MySQLCollation.valueOfName(options.getCollation()) : ((charset = options.getCharset()) == null ? MySQLCollation.DEFAULT_COLLATION : MySQLCollation.valueOfName(MySQLCollation.getDefaultCollationFromCharsetName(charset)));
        Buffer serverRsaPublicKey = null;
        if (options.getServerRsaPublicKeyValue() != null) {
            serverRsaPublicKey = options.getServerRsaPublicKeyValue();
        } else if (options.getServerRsaPublicKeyPath() != null) {
            serverRsaPublicKey = this.context.owner().fileSystem().readFileBlocking(options.getServerRsaPublicKeyPath());
        }
        ChangeUserCommand cmd = new ChangeUserCommand(options.getUser(), options.getPassword(), options.getDatabase(), collation, serverRsaPublicKey, options.getProperties());
        PromiseInternal promise = this.promise();
        this.schedule(cmd, (Promise)promise);
        return promise.future();
    }

    private static /* synthetic */ void lambda$connect$0(MySQLConnectionFactory client, ContextInternal ctx, QueryTracer tracer, Promise promise, Void v) {
        MySQLConnectionImpl.connect(client, ctx, tracer, null, (Promise<MySQLConnection>)promise);
    }
}

