/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.messaging.MessagingRequest;
import brave.messaging.MessagingTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;
import brave.spring.rabbit.MessageConsumerRequest;
import brave.spring.rabbit.MessageProducerRequest;
import brave.spring.rabbit.SpringRabbitPropagation;
import brave.spring.rabbit.TracingMessagePostProcessor;
import brave.spring.rabbit.TracingRabbitListenerAdvice;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public final class SpringRabbitTracing {
    static final String RABBIT_EXCHANGE = "rabbit.exchange";
    static final String RABBIT_ROUTING_KEY = "rabbit.routing_key";
    static final String RABBIT_QUEUE = "rabbit.queue";
    final Tracing tracing;
    final Tracer tracer;
    final TraceContext.Extractor<MessageProducerRequest> producerExtractor;
    final TraceContext.Extractor<MessageConsumerRequest> consumerExtractor;
    final TraceContext.Extractor<MessageProperties> processorExtractor;
    final TraceContext.Injector<MessageProducerRequest> producerInjector;
    final TraceContext.Injector<MessageConsumerRequest> consumerInjector;
    final SamplerFunction<MessagingRequest> producerSampler;
    final SamplerFunction<MessagingRequest> consumerSampler;
    final String[] propagationKeys;
    final String remoteServiceName;
    final Field beforePublishPostProcessorsField;

    public static SpringRabbitTracing create(Tracing tracing) {
        return SpringRabbitTracing.newBuilder(tracing).build();
    }

    public static SpringRabbitTracing create(MessagingTracing messagingTracing) {
        return SpringRabbitTracing.newBuilder(messagingTracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return SpringRabbitTracing.newBuilder(MessagingTracing.create((Tracing)tracing));
    }

    public static Builder newBuilder(MessagingTracing messagingTracing) {
        return new Builder(messagingTracing);
    }

    SpringRabbitTracing(Builder builder) {
        this.tracing = builder.messagingTracing.tracing();
        this.tracer = this.tracing.tracer();
        MessagingTracing messagingTracing = builder.messagingTracing;
        Propagation propagation = this.tracing.propagation();
        this.producerExtractor = propagation.extractor(MessageProducerRequest.GETTER);
        this.consumerExtractor = propagation.extractor(MessageConsumerRequest.GETTER);
        this.processorExtractor = propagation.extractor(SpringRabbitPropagation.GETTER);
        this.producerInjector = propagation.injector(MessageProducerRequest.SETTER);
        this.consumerInjector = propagation.injector(MessageConsumerRequest.SETTER);
        this.producerSampler = messagingTracing.producerSampler();
        this.consumerSampler = messagingTracing.consumerSampler();
        this.propagationKeys = propagation.keys().toArray(new String[0]);
        this.remoteServiceName = builder.remoteServiceName;
        Field beforePublishPostProcessorsField = null;
        try {
            beforePublishPostProcessorsField = RabbitTemplate.class.getDeclaredField("beforePublishPostProcessors");
            beforePublishPostProcessorsField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        this.beforePublishPostProcessorsField = beforePublishPostProcessorsField;
    }

    public RabbitTemplate newRabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        TracingMessagePostProcessor tracingMessagePostProcessor = new TracingMessagePostProcessor(this);
        rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{tracingMessagePostProcessor});
        return rabbitTemplate;
    }

    public RabbitTemplate decorateRabbitTemplate(RabbitTemplate rabbitTemplate) {
        Collection processors;
        if (this.beforePublishPostProcessorsField == null) {
            return rabbitTemplate;
        }
        try {
            processors = (Collection)this.beforePublishPostProcessorsField.get(rabbitTemplate);
        }
        catch (IllegalAccessException e) {
            return rabbitTemplate;
        }
        TracingMessagePostProcessor tracingMessagePostProcessor = new TracingMessagePostProcessor(this);
        if (processors == null) {
            rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{tracingMessagePostProcessor});
            return rabbitTemplate;
        }
        for (MessagePostProcessor processor : processors) {
            if (!(processor instanceof TracingMessagePostProcessor)) continue;
            return rabbitTemplate;
        }
        ArrayList<TracingMessagePostProcessor> newProcessors = new ArrayList<TracingMessagePostProcessor>(processors.size() + 1);
        newProcessors.addAll(processors);
        newProcessors.add(tracingMessagePostProcessor);
        rabbitTemplate.setBeforePublishPostProcessors(newProcessors.toArray(new MessagePostProcessor[0]));
        return rabbitTemplate;
    }

    public SimpleRabbitListenerContainerFactory newSimpleRabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAdviceChain(new Advice[]{new TracingRabbitListenerAdvice(this)});
        return factory;
    }

    public SimpleRabbitListenerContainerFactory decorateSimpleRabbitListenerContainerFactory(SimpleRabbitListenerContainerFactory factory) {
        Advice[] chain = factory.getAdviceChain();
        TracingRabbitListenerAdvice tracingAdvice = new TracingRabbitListenerAdvice(this);
        if (chain == null) {
            factory.setAdviceChain(new Advice[]{tracingAdvice});
            return factory;
        }
        for (Advice advice : chain) {
            if (!(advice instanceof TracingRabbitListenerAdvice)) continue;
            return factory;
        }
        Advice[] newChain = new Advice[chain.length + 1];
        System.arraycopy(chain, 0, newChain, 0, chain.length);
        newChain[chain.length] = tracingAdvice;
        factory.setAdviceChain(newChain);
        return factory;
    }

    <R> TraceContextOrSamplingFlags extractAndClearHeaders(TraceContext.Extractor<R> extractor, R request, Message message) {
        MessageProperties properties;
        TraceContextOrSamplingFlags extracted = extractor.extract(request);
        if (!extracted.equals((Object)TraceContextOrSamplingFlags.EMPTY) && (properties = message.getMessageProperties()) != null) {
            this.clearHeaders(properties.getHeaders());
        }
        return extracted;
    }

    Span nextMessagingSpan(SamplerFunction<MessagingRequest> sampler, MessagingRequest request, TraceContextOrSamplingFlags extracted) {
        Boolean sampled = extracted.sampled();
        if (sampled == null && (sampled = sampler.trySample((Object)request)) != null) {
            extracted = extracted.sampled(sampled.booleanValue());
        }
        return this.tracer.nextSpan(extracted);
    }

    void clearHeaders(Map<String, Object> headers) {
        for (String key : this.propagationKeys) {
            headers.remove(key);
        }
    }

    public static final class Builder {
        final MessagingTracing messagingTracing;
        String remoteServiceName = "rabbitmq";

        Builder(MessagingTracing messagingTracing) {
            if (messagingTracing == null) {
                throw new NullPointerException("messagingTracing == null");
            }
            this.messagingTracing = messagingTracing;
        }

        public Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        @Deprecated
        public Builder writeB3SingleFormat(boolean writeB3SingleFormat) {
            return this;
        }

        public SpringRabbitTracing build() {
            return new SpringRabbitTracing(this);
        }
    }
}

