/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.text.ParseException;
import java.text.SimpleDateFormat;

public interface TypeConverter {
    public static final TypeConverter STRING = new TypeConverter(){

        public Object unmarshal(String value) {
            return value;
        }

        public String marshal(Object value) {
            return (String)value;
        }
    };
    public static final TypeConverter INT = new TypeConverter(){

        public Object unmarshal(String value) {
            return Integer.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeConverter LONG = new TypeConverter(){

        public Object unmarshal(String value) {
            return Long.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeConverter DOUBLE = new TypeConverter(){

        public Object unmarshal(String value) {
            return Double.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeConverter FLOAT = new TypeConverter(){

        public Object unmarshal(String value) {
            return Float.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeConverter SHORT = new TypeConverter(){

        public Object unmarshal(String value) {
            return Short.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeConverter BYTE = new TypeConverter(){

        public Object unmarshal(String value) {
            return Byte.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeConverter CHAR = new TypeConverter(){

        public Object unmarshal(String value) {
            return value == null ? null : new Character(value.charAt(0));
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeConverter JAVA_UTIL_DATE = new TypeConverter(){
        private static final String FORMAT = "yyyy-MM-dd";

        public Object unmarshal(String value) {
            try {
                return new SimpleDateFormat(FORMAT).parse(value);
            }
            catch (ParseException e) {
                throw new IllegalStateException("Failed to parse date string value: " + value);
            }
        }

        public String marshal(Object value) {
            return new SimpleDateFormat(FORMAT).format(value);
        }
    };

    public Object unmarshal(String var1);

    public String marshal(Object var1);
}

