/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Event;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.PingSender;
import org.jgroups.stack.Protocol;

public class PingWaiter
implements Runnable {
    Thread t = null;
    List rsps = new LinkedList();
    long timeout = 3000L;
    int num_rsps = 3;
    Protocol parent = null;
    PingSender ping_sender;
    protected final Log log = LogFactory.getLog(this.getClass());

    public PingWaiter(long timeout, int num_rsps, Protocol parent, PingSender ping_sender) {
        this.timeout = timeout;
        this.num_rsps = num_rsps;
        this.parent = parent;
        this.ping_sender = ping_sender;
    }

    public synchronized void start() {
        if (this.t == null || !this.t.isAlive()) {
            this.t = new Thread((Runnable)this, "PingWaiter");
            this.t.setDaemon(true);
            this.t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.ping_sender != null) {
            this.ping_sender.stop();
        }
        if (this.t != null) {
            this.t = null;
            List list = this.rsps;
            synchronized (list) {
                this.rsps.notifyAll();
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.t != null && this.t.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponse(PingRsp rsp) {
        if (rsp != null) {
            List list = this.rsps;
            synchronized (list) {
                if (this.rsps.contains(rsp)) {
                    this.rsps.remove(rsp);
                }
                this.rsps.add(rsp);
                this.rsps.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResponses() {
        List list = this.rsps;
        synchronized (list) {
            this.rsps.clear();
            this.rsps.notifyAll();
        }
    }

    public List getResponses() {
        return this.rsps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        List list = this.rsps;
        synchronized (list) {
            if (this.rsps.size() > 0) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("clearing old responses: " + this.rsps));
                }
                this.rsps.clear();
            }
            this.ping_sender.start();
            long start_time = System.currentTimeMillis();
            long time_to_wait = this.timeout;
            try {
                while (this.rsps.size() < this.num_rsps && time_to_wait > 0L && this.t != null && Thread.currentThread().equals(this.t)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("waiting for initial members: time_to_wait=" + time_to_wait + ", got " + this.rsps.size() + " rsps"));
                    }
                    try {
                        this.rsps.wait(time_to_wait);
                    }
                    catch (InterruptedException intex) {
                    }
                    catch (Exception e) {
                        this.log.error((Object)"got an exception waiting for responses", (Throwable)e);
                    }
                    time_to_wait = this.timeout - (System.currentTimeMillis() - start_time);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("initial mbrs are " + this.rsps));
                }
                Object var8_7 = null;
                if (this.ping_sender != null) {
                    this.ping_sender.stop();
                }
                if (this.parent != null) {
                    this.parent.passUp(new Event(13, new Vector(this.rsps)));
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (this.ping_sender != null) {
                    this.ping_sender.stop();
                }
                if (this.parent != null) {
                    this.parent.passUp(new Event(13, new Vector(this.rsps)));
                }
                throw throwable;
            }
        }
    }
}

