/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.blocks.MethodCall;
import org.jgroups.stack.RpcProtocol;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class STABLE
extends RpcProtocol {
    private static final String PROT_NAME = "STABLE";
    private static final double SUBSET_SIZE = 0.1;
    private static final int GOSSIP_MSG_INTERVAL = 100;
    private static final int GOSSIP_INTERVAL = 10000;
    private Address local_addr = null;
    private ViewId vid = null;
    private final Vector mbrs = new Vector(11);
    private long round = 1L;
    private long[] seqnos = new long[0];
    private boolean[] heard_from = new boolean[0];
    private double subset = 0.1;
    private TimeScheduler sched = null;
    private Task gossip_task;
    private int max_msgs = 100;
    private long max_wait_time = 10000L;
    private long num_msgs = this.max_msgs;
    private final Object highest_seqnos_mutex = new Object();
    private long highest_seqnos_timeout = 4000L;

    public String getName() {
        return PROT_NAME;
    }

    public Vector requiredUpServices() {
        Vector<Integer> retval = new Vector<Integer>(1);
        retval.addElement(new Integer(35));
        return retval;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("subset");
        if (str != null) {
            this.subset = Float.parseFloat(str);
            props.remove("subset");
        }
        if ((str = props.getProperty("max_msgs")) != null) {
            this.max_msgs = Integer.parseInt(str);
            this.num_msgs = this.max_msgs;
            if (this.max_msgs <= 1) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)"value for 'max_msgs' must be greater than 1 !");
                }
                return false;
            }
            props.remove("max_msgs");
        }
        if ((str = props.getProperty("max_wait_time")) != null) {
            this.max_wait_time = Long.parseLong(str);
            props.remove("max_wait_time");
        }
        if ((str = props.getProperty("highest_seqnos_timeout")) != null) {
            this.highest_seqnos_timeout = Long.parseLong(str);
            props.remove("highest_seqnos_timeout");
        }
        if (props.size() > 0) {
            System.err.println("STABLE.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        TimeScheduler timer;
        super.start();
        TimeScheduler timeScheduler = timer = this.stack != null ? this.stack.timer : null;
        if (timer == null) {
            throw new Exception("STABLE.start(): timer is null");
        }
        this.sched = timer;
        if (this._corr != null) {
            this._corr.setDeadlockDetection(false);
        }
        this.initialize();
        this.startGossip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (this.gossip_task != null) {
                this.gossip_task.cancel();
            }
            this.gossip_task = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gossip(ViewId view_id, long gossip_round, long[] gossip_seqnos, boolean[] heard, Object sender) {
        Object[] params;
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("sender=" + sender + ", round=" + gossip_round + ", seqnos=" + Util.array2String(gossip_seqnos) + ", heard=" + Util.array2String(heard)));
            }
            if (this.vid == null || view_id == null || !this.vid.equals(view_id)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("view ID s are different (" + this.vid + " != " + view_id + "). Discarding gossip received"));
                }
                return;
            }
            if (gossip_round < this.round) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("received a gossip from a previous round (" + gossip_round + "); my round is " + this.round + ". Discarding gossip"));
                }
                return;
            }
            if (gossip_seqnos == null || this.seqnos == null || this.seqnos.length != gossip_seqnos.length) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"size of seqnos and gossip_seqnos are not equal ! Discarding gossip");
                }
                return;
            }
            if (this.round == gossip_round) {
                this.update(sender, gossip_seqnos, heard);
            } else if (this.round < gossip_round) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("received a gossip from a higher round (" + gossip_round + "); adopting my round (" + this.round + ") to " + gossip_round));
                }
                this.round = gossip_round;
                this.set(sender, gossip_seqnos, this.heard_from);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("heard_from=" + Util.array2String(this.heard_from)));
            }
            if (!this.heardFromAll()) {
                return;
            }
            params = new Object[]{this.vid.clone(), new Long(gossip_round), this.seqnos.clone(), this.local_addr};
        }
        MethodCall call = new MethodCall("stability", params, new String[]{ViewId.class.getName(), Long.TYPE.getName(), [J.class.getName(), Object.class.getName()});
        this.callRemoteMethods(null, call, 6, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stability(ViewId view_id, long gossip_round, long[] stability_vector, Object sender) {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("sender=" + sender + ", round=" + gossip_round + ", vector=" + Util.array2String(stability_vector) + ')'));
            }
            if (this.vid == null || view_id == null || !this.vid.equals(view_id)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("view ID s are different (" + this.vid + " != " + view_id + "). Discarding gossip received"));
                }
                return;
            }
            if (this.round > gossip_round) {
                return;
            }
            this.round = gossip_round + 1L;
            for (int i = 0; i < this.heard_from.length; ++i) {
                this.heard_from[i] = false;
            }
        }
        this.heard_from[this.mbrs.indexOf((Object)this.local_addr)] = true;
        this.passUp(new Event(30, stability_vector));
        this.getHighestSeqnos();
    }

    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 1: {
                if (this.upMsg(evt)) break;
                return false;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return true;
    }

    public boolean handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: {
                if (this.downViewChange(evt)) break;
                return false;
            }
            case 36: {
                if (this.downGetMsgsReceived(evt)) break;
                return false;
            }
        }
        return true;
    }

    private void gossipRun() {
        this.num_msgs = this.max_msgs;
        this.sendGossip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            int i;
            this.seqnos = new long[this.mbrs.size()];
            for (i = 0; i < this.seqnos.length; ++i) {
                this.seqnos[i] = -1L;
            }
            this.heard_from = new boolean[this.mbrs.size()];
            for (i = 0; i < this.heard_from.length; ++i) {
                this.heard_from[i] = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Object sender, long[] gossip_seqnos, boolean[] gossip_heard_from) {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            int i;
            int index = this.mbrs.indexOf(sender);
            if (index < 0) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("sender " + sender + " not found in mbrs !"));
                }
                return;
            }
            for (i = 0; i < gossip_seqnos.length; ++i) {
                this.seqnos[i] = Math.min(this.seqnos[i], gossip_seqnos[i]);
            }
            this.heard_from[index] = true;
            for (i = 0; i < this.heard_from.length; ++i) {
                this.heard_from[i] = this.heard_from[i] | gossip_heard_from[i];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(Object sender, long[] gossip_seqnos, boolean[] gossip_heard_from) {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            int index = this.mbrs.indexOf(sender);
            if (index < 0) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("sender " + sender + " not found in mbrs !"));
                }
                return;
            }
            this.seqnos = gossip_seqnos;
            this.heard_from = gossip_heard_from;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean heardFromAll() {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (this.heard_from == null) {
                return false;
            }
            for (int i = 0; i < this.heard_from.length; ++i) {
                if (this.heard_from[i]) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendGossip() {
        Object[] params;
        Vector gossip_subset;
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            gossip_subset = Util.pickSubset(this.mbrs, this.subset);
            if (gossip_subset == null || gossip_subset.size() < 1) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"picked empty subset !");
                }
                return;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("subset=" + gossip_subset + ", round=" + this.round + ", seqnos=" + Util.array2String(this.seqnos)));
            }
            params = new Object[]{this.vid.clone(), new Long(this.round), this.seqnos.clone(), this.heard_from.clone(), this.local_addr};
        }
        MethodCall call = new MethodCall("gossip", params, new String[]{ViewId.class.getName(), Long.TYPE.getName(), [J.class.getName(), [Z.class.getName(), Object.class.getName()});
        for (int i = 0; i < gossip_subset.size(); ++i) {
            try {
                this.callRemoteMethod((Address)gossip_subset.get(i), call, 6, 0L);
                continue;
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("exception=" + e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHighestSeqnos() {
        Object object = this.highest_seqnos_mutex;
        synchronized (object) {
            block5: {
                this.passUp(new Event(35));
                try {
                    this.highest_seqnos_mutex.wait(this.highest_seqnos_timeout);
                }
                catch (InterruptedException e) {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error((Object)"Interrupted while waiting for highest seqnos from NAKACK");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startGossip() {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (this.gossip_task != null) {
                this.gossip_task.cancel();
            }
            this.gossip_task = new Task(new Times(new long[]{10000L}));
            this.sched.add(this.gossip_task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upMsg(Event e) {
        Message msg = (Message)e.getArg();
        if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) {
            return true;
        }
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            --this.num_msgs;
            if (this.num_msgs > 0L) {
                return true;
            }
            this.num_msgs = this.max_msgs;
            this.gossip_task.cancel();
            this.gossip_task = new Task(new Times(new long[]{0L, 10000L}));
            this.sched.add(this.gossip_task);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downViewChange(Event e) {
        View v = (View)e.getArg();
        Vector new_mbrs = v.getMembers();
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            this.vid = v.getVid();
            this.mbrs.clear();
            this.mbrs.addAll(new_mbrs);
            this.initialize();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downGetMsgsReceived(Event e) {
        block16: {
            boolean bl;
            block15: {
                Object object;
                boolean bl2;
                block14: {
                    long[] new_seqnos = (long[])e.getArg();
                    try {
                        STABLE sTABLE = this;
                        synchronized (sTABLE) {
                            if (new_seqnos == null) {
                                bl2 = true;
                                // MONITOREXIT @DISABLED, blocks:[0, 5, 13] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                                Object var7_6 = null;
                                object = this.highest_seqnos_mutex;
                                break block14;
                            }
                            if (new_seqnos.length != this.seqnos.length) {
                                if (this.log.isInfoEnabled()) {
                                    this.log.info((Object)("GET_MSGS_RECEIVED: array of highest seqnos seen so far (received from NAKACK layer) has a different length (" + new_seqnos.length + ") from 'seqnos' array (" + this.seqnos.length + ')'));
                                }
                                bl = true;
                                // MONITOREXIT @DISABLED, blocks:[0, 5, 12] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                                break block15;
                            }
                            System.arraycopy(new_seqnos, 0, this.seqnos, 0, this.seqnos.length);
                        }
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        Object object2 = this.highest_seqnos_mutex;
                        synchronized (object2) {
                            this.highest_seqnos_mutex.notifyAll();
                            throw throwable;
                        }
                    }
                }
                synchronized (object) {
                    this.highest_seqnos_mutex.notifyAll();
                    return bl2;
                }
            }
            Object var7_7 = null;
            Object object = this.highest_seqnos_mutex;
            synchronized (object) {
                this.highest_seqnos_mutex.notifyAll();
                return bl;
            }
        }
        Object var7_8 = null;
        Object object = this.highest_seqnos_mutex;
        synchronized (object) {
            this.highest_seqnos_mutex.notifyAll();
            return true;
        }
    }

    private class Task
    implements TimeScheduler.Task {
        private final Times intervals;
        private boolean cancelled = false;

        public Task(Times intervals) {
            this.intervals = intervals;
        }

        public long nextInterval() {
            return this.intervals.next();
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void run() {
            STABLE.this.gossipRun();
        }
    }

    private static class Times {
        private int next = 0;
        private long[] times;

        public Times(long[] times) {
            if (times.length == 0) {
                throw new IllegalArgumentException("times");
            }
            this.times = times;
        }

        public synchronized long next() {
            if (this.next >= this.times.length) {
                return this.times[this.times.length - 1];
            }
            return this.times[this.next++];
        }

        public long[] times() {
            return this.times;
        }

        public synchronized void reset() {
            this.next = 0;
        }
    }
}

